/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottledCaterpillarItem
extends BlockItem {
    public static final String BOTTLED_CATERPILLAR_STRING = "block.butterflies.bottled_caterpillar";
    public static final String BOTTLED_LARVA_STRING = "block.butterflies.bottled_larva";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public BottledCaterpillarItem(Item.Properties properties, RegistryObject<Block> block, int butterflyIndex) {
        super((Block)block.get(), properties);
        this.butterflyIndex = butterflyIndex;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            ResourceLocation caterpillarEntity = data.getCaterpillarEntity();
            String translatable = "entity." + caterpillarEntity.toString().replace(':', '.');
            TranslatableComponent speciesComponent = new TranslatableComponent(translatable);
            Style speciesStyle = speciesComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131155_(Boolean.valueOf(true));
            speciesComponent.m_6270_(speciesStyle);
            components.add((Component)speciesComponent);
            TranslatableComponent tooltipComponent = new TranslatableComponent("tooltip.butterflies.release_caterpillar");
            Style tooltipStyle = tooltipComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true));
            tooltipComponent.m_6270_(tooltipStyle);
            components.add((Component)tooltipComponent);
            super.m_7373_(stack, level, components, tooltipFlag);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack itemStack) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && data.type() == ButterflyData.ButterflyType.MOTH) {
            return new TranslatableComponent(BOTTLED_LARVA_STRING);
        }
        return new TranslatableComponent(BOTTLED_CATERPILLAR_STRING);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext context) {
        ButterflyData data;
        InteractionResult result = super.m_40576_(context);
        if (result == InteractionResult.CONSUME && (data = ButterflyData.getEntry(this.butterflyIndex)) != null) {
            Caterpillar.spawn((ServerLevel)context.m_43725_(), data.getCaterpillarEntity(), context.m_8083_(), Direction.DOWN, true);
        }
        return result;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            ResourceLocation location = data.getCaterpillarItem();
            Item caterpillarItem = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (caterpillarItem != null) {
                ItemStack caterpillarStack = new ItemStack((ItemLike)caterpillarItem, 1);
                player.m_36356_(caterpillarStack);
            }
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }
}

