/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.client.gui.screens.ButterflyBookScreen;
import com.bokmcdok.butterflies.world.ButterflyData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButterflyBookItem
extends Item {
    public static final String NAME = "butterfly_book";

    public static boolean addPage(@NotNull ItemStack newBook, int index) {
        boolean result = false;
        ListTag newPages = new ListTag();
        CompoundTag tag = newBook.m_41784_();
        if (tag.m_128441_("pages")) {
            newPages = tag.m_128437_("pages", 3);
        }
        if (!newPages.contains((Object)IntTag.m_128679_((int)index))) {
            newPages.add((Object)IntTag.m_128679_((int)index));
            result = true;
        }
        int numButterflies = 0;
        int numMoths = 0;
        for (Tag i : newPages) {
            IntTag intTag;
            ButterflyData data;
            if (!(i instanceof IntTag) || (data = ButterflyData.getEntry((intTag = (IntTag)i).m_7047_())) == null) continue;
            if (data.type() == ButterflyData.ButterflyType.BUTTERFLY) {
                ++numButterflies;
                continue;
            }
            if (data.type() != ButterflyData.ButterflyType.MOTH) continue;
            ++numMoths;
        }
        CompoundTag newTag = newBook.m_41784_();
        newTag.m_128365_("pages", (Tag)newPages);
        int customModelData = 0;
        if (numButterflies >= ButterflyData.getNumButterflySpecies()) {
            ++customModelData;
        }
        if (numMoths >= ButterflyData.getNumMothSpecies()) {
            customModelData += 2;
        }
        newTag.m_128405_("CustomModelData", customModelData);
        return result;
    }

    public ButterflyBookItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        String localisation = "tooltip.butterflies.pages";
        int numPages = 0;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("pages")) {
            ListTag newPages = tag.m_128437_("pages", 3);
            numPages = 2 * newPages.size();
        }
        TranslatableComponent newComponent = new TranslatableComponent(localisation, new Object[]{numPages});
        Style style = newComponent.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131155_(Boolean.valueOf(true));
        newComponent.m_6270_(style);
        components.add((Component)newComponent);
        super.m_7373_(stack, level, components, tooltipFlag);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (level.m_5776_()) {
            this.openScreen(itemStack);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(ItemStack book) {
        Minecraft.m_91087_().m_91152_((Screen)new ButterflyBookScreen(book));
    }
}

