/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyScrollModel;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.decoration.ButterflyScroll;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyScrollRenderer
extends EntityRenderer<ButterflyScroll> {
    private final ButterflyScrollModel model;

    public ButterflyScrollRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ButterflyScrollModel(context.m_174023_(ButterflyScrollModel.LAYER_LOCATION));
    }

    public float getScale() {
        return 0.088f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ButterflyScroll scroll) {
        ButterflyData data = ButterflyData.getEntry(scroll.getButterflyIndex());
        return data == null ? new ResourceLocation("butterflies", "textures/gui/butterfly_scroll/admiral.png") : data.getScrollTexture();
    }

    public void render(@NotNull ButterflyScroll scroll, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffers, int overlay) {
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(scroll.m_6350_().m_122416_() * -90)));
        poseStack.m_85837_(0.31, -0.31, -0.075);
        float scale = this.getScale();
        poseStack.m_85841_(scale, -scale, -scale);
        RenderType renderType = RenderType.m_110476_((ResourceLocation)this.getTextureLocation(scroll));
        VertexConsumer vertexConsumer = buffers.m_6299_(renderType);
        this.model.m_7695_(poseStack, vertexConsumer, overlay, 0, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

