/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class ModEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public ModEventListener(IEventBus modEventBus, EntityTypeRegistry entityTypeRegistry) {
        modEventBus.register((Object)this);
        modEventBus.addListener(this::onCommonSetup);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        for (RegistryObject<EntityType<? extends Butterfly>> registryObject : this.entityTypeRegistry.getButterflies()) {
            SpawnPlacements.m_21754_((EntityType)((EntityType)registryObject.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, Butterfly::checkButterflySpawnRules);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getCaterpillars()) {
            SpawnPlacements.m_21754_((EntityType)((EntityType)registryObject.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getChrysalises()) {
            SpawnPlacements.m_21754_((EntityType)((EntityType)registryObject.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules);
        }
        for (RegistryObject registryObject : this.entityTypeRegistry.getButterflyEggs()) {
            SpawnPlacements.m_21754_((EntityType)((EntityType)registryObject.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules);
        }
    }
}

