/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.model;

import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.IronGolem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyGolemModel
extends IronGolemModel<IronGolem> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("butterflies", "butterfly_golem"), "main");
    private final ModelPart leftWing = this.root().getChild("left_wing");
    private final ModelPart rightWing = this.root().getChild("right_wing");

    public ButterflyGolemModel(ModelPart modelPart) {
        super(modelPart);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f).texOffs(24, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f).texOffs(0, 18).addBox(-7.0f, -15.0f, -1.0f, 14.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 40).addBox(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f).texOffs(0, 70).addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(60, 21).addBox(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(60, 58).addBox(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).mirror().addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f), PartPose.offset((float)5.0f, (float)11.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(20, 87).addBox(0.0f, -18.0f, 0.0f, 20.0f, 41.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 87).addBox(-20.0f, -18.0f, 0.0f, 20.0f, 41.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)5.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull IronGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightWing.yRot = Mth.sin((float)(ageInTicks * 0.1f)) * 0.1f + 0.5f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftWing.yRot = Mth.sin((float)(ageInTicks * 0.1f)) * -0.1f - 0.5f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
    }
}

