/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyModel;
import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyRenderer
extends MobRenderer<Butterfly, ButterflyModel> {
    public ButterflyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ButterflyModel(context.bakeLayer(ButterflyModel.LAYER_LOCATION)), 0.2f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Butterfly entity) {
        return entity.getTexture();
    }

    public void render(@NotNull Butterfly entity, float p_115456_, float p_115457_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(entity, poseStack, multiBufferSource, this.entityRenderDispatcher.cameraOrientation(), this.getFont(), packedLightCoordinates);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        super.render((Mob)entity, p_115456_, p_115457_, poseStack, multiBufferSource, packedLightCoordinates);
        poseStack.popPose();
    }

    protected void scale(@NotNull Butterfly entity, PoseStack poses, float scale) {
        float s = entity.getRenderScale();
        poses.scale(s, s, s);
    }
}

