/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.entity.living;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class MobSpawnEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public MobSpawnEventListener(IEventBus forgeEventBus, EntityTypeRegistry entityTypeRegistry) {
        forgeEventBus.register((Object)this);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    @SubscribeEvent
    private void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        IronGolem ironGolem;
        if (event.getEntity().getType() == EntityType.IRON_GOLEM && (ironGolem = (IronGolem)event.getEntity()).getRandom().nextInt() % 256 == 1) {
            IronGolem newMob;
            ServerLevelAccessor level = event.getLevel();
            EntityType entityType = (EntityType)this.entityTypeRegistry.getButterflyGolem().get();
            if (EventHooks.canLivingConvert((LivingEntity)ironGolem, (EntityType)entityType, x -> {}) && (newMob = (IronGolem)ironGolem.convertTo(entityType, false)) != null) {
                newMob.finalizeSpawn(level, level.getCurrentDifficultyAt(newMob.blockPosition()), MobSpawnType.CONVERSION, null, null);
                EventHooks.onLivingConvert((LivingEntity)ironGolem, (LivingEntity)newMob);
                if (!newMob.isSilent()) {
                    level.levelEvent(null, 1026, newMob.blockPosition(), 0);
                }
            }
        }
    }
}

