/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.lifecycle;

import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyFeederScreen;
import com.bokmcdok.butterflies.client.gui.screens.inventory.ButterflyMicroscopeScreen;
import com.bokmcdok.butterflies.registries.DecoratedPotPatternsRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.brewing.BrewingRecipeRegistry;

public class LifecycleEventListener {
    private final DecoratedPotPatternsRegistry decoratedPotPatternsRegistry;
    private final ItemRegistry itemRegistry;
    private final MenuTypeRegistry menuTypeRegistry;

    public LifecycleEventListener(IEventBus modEventBus, DecoratedPotPatternsRegistry decoratedPotPatternsRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        modEventBus.register((Object)this);
        this.decoratedPotPatternsRegistry = decoratedPotPatternsRegistry;
        this.itemRegistry = itemRegistry;
        this.menuTypeRegistry = menuTypeRegistry;
    }

    @SubscribeEvent
    private void commonSetup(FMLCommonSetupEvent event) {
        int monarchIndex = Arrays.asList(ButterflySpeciesList.SPECIES).indexOf("monarch");
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.AWKWARD)}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)this.itemRegistry.getBottledButterflies().get(monarchIndex).get()}), (ItemStack)PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.POISON));
        HashMap itemToPotTextureMap = Maps.newHashMap((Map)DecoratedPotPatterns.ITEM_TO_POT_TEXTURE);
        itemToPotTextureMap.put((Item)this.itemRegistry.getButterflyPotterySherd().get(), this.decoratedPotPatternsRegistry.getButterflyPotPattern().getKey());
        DecoratedPotPatterns.ITEM_TO_POT_TEXTURE = itemToPotTextureMap;
    }

    @SubscribeEvent
    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.register((MenuType)((MenuType)this.menuTypeRegistry.getButterflyFeederMenu().get()), ButterflyFeederScreen::new));
        event.enqueueWork(() -> MenuScreens.register((MenuType)((MenuType)this.menuTypeRegistry.getButterflyMicroscopeMenu().get()), ButterflyMicroscopeScreen::new));
    }
}

