/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangziItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private List<DeferredHolder<Item, Item>> bottledButterflies;
    private List<DeferredHolder<Item, Item>> bottledCaterpillars;
    private DeferredHolder<Item, Item> burntButterflyNet;
    private DeferredHolder<Item, Item> butterflyBannerPattern;
    private DeferredHolder<Item, Item> butterflyBook;
    private List<DeferredHolder<Item, Item>> butterflyEggs;
    private DeferredHolder<Item, Item> butterflyFeeder;
    private DeferredHolder<Item, Item> butterflyMicroscope;
    private List<DeferredHolder<Item, Item>> butterflyNets;
    private DeferredHolder<Item, Item> butterflyPotterySherd;
    private List<DeferredHolder<Item, Item>> butterflyScrolls;
    private DeferredHolder<Item, Item> butterflyGolemSpawnEgg;
    private List<DeferredHolder<Item, Item>> butterflySpawnEggs;
    private List<DeferredHolder<Item, Item>> caterpillars;
    private List<DeferredHolder<Item, Item>> caterpillarSpawnEggs;
    private DeferredHolder<Item, Item> emptyButterflyNet;
    private DeferredHolder<Item, Item> infestedApple;
    private DeferredHolder<Item, Item> silk;
    private DeferredHolder<Item, Item> zhuangziBook;
    private DeferredHolder<Item, Item> butterflyOrigamiBlack;
    private DeferredHolder<Item, Item> butterflyOrigamiBlue;
    private DeferredHolder<Item, Item> butterflyOrigamiBrown;
    private DeferredHolder<Item, Item> butterflyOrigamiCyan;
    private DeferredHolder<Item, Item> butterflyOrigamiGray;
    private DeferredHolder<Item, Item> butterflyOrigamiGreen;
    private DeferredHolder<Item, Item> butterflyOrigamiLightBlue;
    private DeferredHolder<Item, Item> butterflyOrigamiLightGray;
    private DeferredHolder<Item, Item> butterflyOrigamiLime;
    private DeferredHolder<Item, Item> butterflyOrigamiMagenta;
    private DeferredHolder<Item, Item> butterflyOrigamiOrange;
    private DeferredHolder<Item, Item> butterflyOrigamiPink;
    private DeferredHolder<Item, Item> butterflyOrigamiPurple;
    private DeferredHolder<Item, Item> butterflyOrigamiRed;
    private DeferredHolder<Item, Item> butterflyOrigamiWhite;
    private DeferredHolder<Item, Item> butterflyOrigamiYellow;

    public ItemRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BannerPatternRegistry bannerPatternRegistry, BlockRegistry blockRegistry, EntityTypeRegistry entityTypeRegistry) {
        this.blockRegistry = blockRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
        this.bottledButterflies = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledButterfly(i));
                }
            }
        };
        this.bottledCaterpillars = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledCaterpillar(i));
                }
            }
        };
        this.burntButterflyNet = this.deferredRegister.register("butterfly_net_burnt", () -> new Item(new Item.Properties()));
        this.butterflyBannerPattern = this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON)));
        this.butterflyBook = this.deferredRegister.register("butterfly_book", ButterflyBookItem::new);
        this.butterflyEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)blockRegistry.getButterflyFeeder().get(), new Item.Properties()));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)blockRegistry.getButterflyMicroscope().get(), new Item.Properties()));
        this.butterflyNets = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyNet(i));
                }
            }
        };
        this.butterflyOrigamiBlack = this.registerButterflyOrigami("butterfly_origami_black", blockRegistry.getButterflyOrigamiBlack());
        this.butterflyOrigamiBlue = this.registerButterflyOrigami("butterfly_origami_blue", blockRegistry.getButterflyOrigamiBlue());
        this.butterflyOrigamiBrown = this.registerButterflyOrigami("butterfly_origami_brown", blockRegistry.getButterflyOrigamiBrown());
        this.butterflyOrigamiCyan = this.registerButterflyOrigami("butterfly_origami_cyan", blockRegistry.getButterflyOrigamiCyan());
        this.butterflyOrigamiGray = this.registerButterflyOrigami("butterfly_origami_gray", blockRegistry.getButterflyOrigamiGray());
        this.butterflyOrigamiGreen = this.registerButterflyOrigami("butterfly_origami_green", blockRegistry.getButterflyOrigamiGreen());
        this.butterflyOrigamiLightBlue = this.registerButterflyOrigami("butterfly_origami_light_blue", blockRegistry.getButterflyOrigamiLightBlue());
        this.butterflyOrigamiLightGray = this.registerButterflyOrigami("butterfly_origami_light_gray", blockRegistry.getButterflyOrigamiLightGray());
        this.butterflyOrigamiLime = this.registerButterflyOrigami("butterfly_origami_lime", blockRegistry.getButterflyOrigamiLime());
        this.butterflyOrigamiMagenta = this.registerButterflyOrigami("butterfly_origami_magenta", blockRegistry.getButterflyOrigamiMagenta());
        this.butterflyOrigamiOrange = this.registerButterflyOrigami("butterfly_origami_orange", blockRegistry.getButterflyOrigamiOrange());
        this.butterflyOrigamiPink = this.registerButterflyOrigami("butterfly_origami_pink", blockRegistry.getButterflyOrigamiPink());
        this.butterflyOrigamiPurple = this.registerButterflyOrigami("butterfly_origami_purple", blockRegistry.getButterflyOrigamiPurple());
        this.butterflyOrigamiRed = this.registerButterflyOrigami("butterfly_origami_red", blockRegistry.getButterflyOrigamiRed());
        this.butterflyOrigamiWhite = this.registerButterflyOrigami("butterfly_origami_white", blockRegistry.getButterflyOrigamiWhite());
        this.butterflyOrigamiYellow = this.registerButterflyOrigami("butterfly_origami_yellow", blockRegistry.getButterflyOrigamiYellow());
        this.butterflyPotterySherd = this.deferredRegister.register("butterfly_pottery_sherd", () -> new Item(new Item.Properties()));
        this.butterflyScrolls = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyScroll(i));
                }
            }
        };
        this.butterflyGolemSpawnEgg = this.deferredRegister.register("butterfly_golem", () -> new SpawnEggItem((EntityType)entityTypeRegistry.getButterflyGolem().get(), 0x888800, 0x333333, new Item.Properties()));
        this.butterflySpawnEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflySpawnEgg(i));
                }
            }
        };
        this.caterpillars = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.caterpillarSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillarSpawnEgg(i));
                }
            }
        };
        this.emptyButterflyNet = this.deferredRegister.register("butterfly_net", () -> new ButterflyNetItem(this, -1));
        this.infestedApple = this.deferredRegister.register("infested_apple", () -> new Item(new Item.Properties()));
        this.silk = this.deferredRegister.register("silk", () -> new Item(new Item.Properties()));
        this.zhuangziBook = this.deferredRegister.register("butterfly_zhuangzi", ButterflyZhuangziItem::new);
    }

    public List<DeferredHolder<Item, Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<DeferredHolder<Item, Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public DeferredHolder<Item, Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public DeferredHolder<Item, Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public DeferredHolder<Item, Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public DeferredHolder<Item, Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<DeferredHolder<Item, Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<Item, Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflySpeciesList.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public DeferredHolder<Item, Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<DeferredHolder<Item, Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBlack() {
        return this.butterflyOrigamiBlack;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBlue() {
        return this.butterflyOrigamiBlue;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiBrown() {
        return this.butterflyOrigamiBrown;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiCyan() {
        return this.butterflyOrigamiCyan;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiGray() {
        return this.butterflyOrigamiGray;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiGreen() {
        return this.butterflyOrigamiGreen;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLightBlue() {
        return this.butterflyOrigamiLightBlue;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLightGray() {
        return this.butterflyOrigamiLightGray;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiLime() {
        return this.butterflyOrigamiLime;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiMagenta() {
        return this.butterflyOrigamiMagenta;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiOrange() {
        return this.butterflyOrigamiOrange;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiPink() {
        return this.butterflyOrigamiPink;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiPurple() {
        return this.butterflyOrigamiPurple;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiRed() {
        return this.butterflyOrigamiRed;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiWhite() {
        return this.butterflyOrigamiWhite;
    }

    public DeferredHolder<Item, Item> getButterflyOrigamiYellow() {
        return this.butterflyOrigamiYellow;
    }

    public DeferredHolder<Item, Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<DeferredHolder<Item, Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<DeferredHolder<Item, Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public DeferredHolder<Item, Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public DeferredHolder<Item, Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public DeferredHolder<Item, Item> getInfestedApple() {
        return this.infestedApple;
    }

    public DeferredHolder<Item, Item> getSilk() {
        return this.silk;
    }

    public DeferredHolder<Item, Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyNetItem.getRegistryId(butterflyIndex), () -> new ButterflyNetItem(this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledButterfly(int butterflyIndex) {
        return this.deferredRegister.register(BottledButterflyItem.getRegistryId(butterflyIndex), () -> new BottledButterflyItem(this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(BottledCaterpillarItem.getRegistryId(butterflyIndex), () -> new BottledCaterpillarItem(this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyEgg(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyEggItem.getRegistryId(butterflyIndex), () -> new ButterflyEggItem(butterflyIndex, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerButterflyOrigami(String id, DeferredHolder<Block, Block> block) {
        return this.deferredRegister.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerButterflyScroll(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyScrollItem.getRegistryId(butterflyIndex), () -> new ButterflyScrollItem(this.entityTypeRegistry, this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflySpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register(Butterfly.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getButterflies().get(butterflyIndex).get(), 0x880000, 35071, new Item.Properties()));
    }

    private DeferredHolder<Item, Item> registerCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(CaterpillarItem.getRegistryId(butterflyIndex), () -> new CaterpillarItem(Caterpillar.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<Item, Item> registerCaterpillarSpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register(Caterpillar.getRegistryId(butterflyIndex), () -> new SpawnEggItem((EntityType)this.entityTypeRegistry.getCaterpillars().get(butterflyIndex).get(), 35071, 0x880000, new Item.Properties()));
    }
}

