/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public class ButterflyRestGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;

    public ButterflyRestGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public boolean canContinueToUse() {
        return !this.butterfly.getIsActive() && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos);
    }

    public boolean canUse() {
        if (!this.butterfly.getIsActive()) {
            this.nextStartTick = 0;
            return super.canUse();
        }
        return false;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.butterfly.setLanded(false);
        super.stop();
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            this.butterfly.setLanded(true);
        }
    }

    @NotNull
    public String toString() {
        return "Rest / Target = [" + this.getMoveToTarget() + "] / Position = [" + this.butterfly.getOnPos() + "] / Reached = [" + this.isReachedTarget() + "] / Landed = [" + this.butterfly.getIsLanded() + "]";
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (levelReader.isEmptyBlock(blockPos.above()) && this.butterfly.isValidLandingBlock(levelReader.getBlockState(blockPos))) {
            return blockPos.getY() < this.butterfly.getBlockY();
        }
        return false;
    }

    public double acceptedDistance() {
        return 0.5;
    }
}

