/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.block.entity.ButterflyFeederEntity;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ButterflyPollinateFlowerGoal
extends MoveToBlockGoal {
    private final Butterfly butterfly;
    private final Block preferredFlowerBlock;
    private final Item preferredFlowerItem;
    public final RandomSource random;
    public boolean attemptedToPollinate;

    public ButterflyPollinateFlowerGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
        ButterflyData data = ButterflyData.getEntry(this.butterfly.getButterflyIndex());
        if (data != null) {
            this.preferredFlowerBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(data.preferredFlower());
            this.preferredFlowerItem = (Item)BuiltInRegistries.f_257033_.m_7745_(data.preferredFlower());
        } else {
            this.preferredFlowerBlock = null;
            this.preferredFlowerItem = null;
        }
        this.random = this.butterfly.m_217043_();
    }

    public double m_8052_() {
        return 2.0;
    }

    public boolean m_8045_() {
        return this.butterfly.getIsActive() && super.m_8045_();
    }

    public boolean m_8036_() {
        return this.butterfly.getIsActive() && super.m_8036_();
    }

    public void m_8056_() {
        this.attemptedToPollinate = false;
        super.m_8056_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            this.f_25601_ -= 11;
            Vec3 deltaMovement = this.butterfly.m_20184_();
            this.butterfly.m_20334_(0.0, deltaMovement.f_82480_, 0.0);
            if (!this.attemptedToPollinate) {
                BlockState blockState;
                Block budBlock;
                BlockPos spawnPos;
                this.attemptedToPollinate = true;
                BlockEntity blockEntity = this.butterfly.m_9236_().m_7702_(this.f_25602_);
                if (blockEntity instanceof ButterflyFeederEntity) {
                    ButterflyFeederEntity feeder = (ButterflyFeederEntity)blockEntity;
                    if (feeder.m_8020_(0).m_150930_(this.preferredFlowerItem)) {
                        this.butterfly.setNumEggs(1);
                        feeder.m_7407_(0, 1);
                    }
                } else if (this.random.m_188502_() % 5 == 0 && (spawnPos = this.findNearestFlowerSpot()) != null && (budBlock = this.getFlowerBud((blockState = this.f_25598_.m_9236_().m_8055_(this.f_25602_)).m_60734_())) != null) {
                    this.f_25598_.m_9236_().m_46597_(spawnPos, budBlock.m_49966_());
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "Pollinate Flower / Target = [" + this.m_6669_() + "] / Reached Target = [" + this.m_25625_() + "] / Attempted to Pollinate = [" + this.attemptedToPollinate + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }

    protected boolean m_6465_(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        ButterflyFeederEntity feeder;
        BlockEntity blockEntity;
        if (!levelReader.m_8055_(blockPos.m_7494_()).m_60795_()) {
            return false;
        }
        if (this.butterfly.getNumEggs() == 0 && (blockEntity = levelReader.m_7702_(blockPos)) instanceof ButterflyFeederEntity && (feeder = (ButterflyFeederEntity)blockEntity).m_8020_(0).m_150930_(this.preferredFlowerItem)) {
            return true;
        }
        BlockState blockState = levelReader.m_8055_(blockPos);
        if (blockState.m_60713_(this.preferredFlowerBlock)) {
            return true;
        }
        if (blockState.m_204336_(BlockTags.f_13037_)) {
            return this.random.m_188502_() % 2 == 0;
        }
        return false;
    }

    private BlockPos findNearestFlowerSpot() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int yOffset = this.f_25603_;
        while (yOffset <= 2) {
            for (int range = 0; range < 2; ++range) {
                int xOffset = 0;
                while (xOffset <= range) {
                    int zOffset;
                    int n = zOffset = xOffset < range && xOffset > -range ? range : 0;
                    while (zOffset <= range) {
                        mutableBlockPos.m_122154_((Vec3i)this.f_25602_, xOffset, yOffset - 1, zOffset);
                        Block requiredBlock = Blocks.f_50440_;
                        if (this.f_25598_.m_9236_().m_8055_(this.f_25602_).m_60713_(Blocks.f_271329_)) {
                            requiredBlock = Blocks.f_50093_;
                        }
                        if (this.f_25598_.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60795_() && this.f_25598_.m_9236_().m_8055_(mutableBlockPos.m_7495_()).m_60713_(requiredBlock)) {
                            return mutableBlockPos;
                        }
                        zOffset = zOffset > 0 ? -zOffset : 1 - zOffset;
                    }
                    xOffset = xOffset > 0 ? -xOffset : 1 - xOffset;
                }
            }
            yOffset = yOffset > 0 ? -yOffset : 1 - yOffset;
        }
        return null;
    }

    private Block getFlowerBud(Block flowerBlock) {
        if (flowerBlock == Blocks.f_50114_) {
            return (Block)this.butterfly.getBlockRegistry().getAlliumBud().get();
        }
        if (flowerBlock == Blocks.f_50115_) {
            return (Block)this.butterfly.getBlockRegistry().getAzureBluetBud().get();
        }
        if (flowerBlock == Blocks.f_50113_) {
            return (Block)this.butterfly.getBlockRegistry().getBlueOrchidBud().get();
        }
        if (flowerBlock == Blocks.f_50121_) {
            return (Block)this.butterfly.getBlockRegistry().getCornflowerBud().get();
        }
        if (flowerBlock == Blocks.f_50111_) {
            return (Block)this.butterfly.getBlockRegistry().getDandelionBud().get();
        }
        if (flowerBlock == Blocks.f_50071_) {
            return (Block)this.butterfly.getBlockRegistry().getLilyOfTheValleyBud().get();
        }
        if (flowerBlock == Blocks.f_50117_) {
            return (Block)this.butterfly.getBlockRegistry().getOrangeTulipBud().get();
        }
        if (flowerBlock == Blocks.f_50120_) {
            return (Block)this.butterfly.getBlockRegistry().getOxeyeDaisyBud().get();
        }
        if (flowerBlock == Blocks.f_50119_) {
            return (Block)this.butterfly.getBlockRegistry().getPinkTulipBud().get();
        }
        if (flowerBlock == Blocks.f_50112_) {
            return (Block)this.butterfly.getBlockRegistry().getPoppyBud().get();
        }
        if (flowerBlock == Blocks.f_50116_) {
            return (Block)this.butterfly.getBlockRegistry().getRedTulipBud().get();
        }
        if (flowerBlock == Blocks.f_271329_) {
            return Blocks.f_271410_;
        }
        if (flowerBlock == Blocks.f_50118_) {
            return (Block)this.butterfly.getBlockRegistry().getWhiteTulipBud().get();
        }
        if (flowerBlock == Blocks.f_50070_) {
            return (Block)this.butterfly.getBlockRegistry().getWitherRoseBud().get();
        }
        if (flowerBlock == Blocks.f_50685_) {
            return Blocks.f_50685_;
        }
        return null;
    }
}

