/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangziItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private List<RegistryObject<Item>> bottledButterflies;
    private List<RegistryObject<Item>> bottledCaterpillars;
    private RegistryObject<Item> burntButterflyNet;
    private RegistryObject<Item> butterflyBannerPattern;
    private RegistryObject<Item> butterflyBook;
    private List<RegistryObject<Item>> butterflyEggs;
    private RegistryObject<Item> butterflyFeeder;
    private RegistryObject<Item> butterflyMicroscope;
    private List<RegistryObject<Item>> butterflyNets;
    private RegistryObject<Item> butterflyPotterySherd;
    private List<RegistryObject<Item>> butterflyScrolls;
    private RegistryObject<Item> butterflyGolemSpawnEgg;
    private List<RegistryObject<Item>> butterflySpawnEggs;
    private List<RegistryObject<Item>> caterpillars;
    private List<RegistryObject<Item>> caterpillarSpawnEggs;
    private RegistryObject<Item> emptyButterflyNet;
    private RegistryObject<Item> infestedApple;
    private RegistryObject<Item> silk;
    private RegistryObject<Item> zhuangziBook;
    private RegistryObject<Item> butterflyOrigamiBlack;
    private RegistryObject<Item> butterflyOrigamiBlue;
    private RegistryObject<Item> butterflyOrigamiBrown;
    private RegistryObject<Item> butterflyOrigamiCyan;
    private RegistryObject<Item> butterflyOrigamiGray;
    private RegistryObject<Item> butterflyOrigamiGreen;
    private RegistryObject<Item> butterflyOrigamiLightBlue;
    private RegistryObject<Item> butterflyOrigamiLightGray;
    private RegistryObject<Item> butterflyOrigamiLime;
    private RegistryObject<Item> butterflyOrigamiMagenta;
    private RegistryObject<Item> butterflyOrigamiOrange;
    private RegistryObject<Item> butterflyOrigamiPink;
    private RegistryObject<Item> butterflyOrigamiPurple;
    private RegistryObject<Item> butterflyOrigamiRed;
    private RegistryObject<Item> butterflyOrigamiWhite;
    private RegistryObject<Item> butterflyOrigamiYellow;

    public ItemRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(BannerPatternRegistry bannerPatternRegistry, BlockRegistry blockRegistry, EntityTypeRegistry entityTypeRegistry) {
        this.blockRegistry = blockRegistry;
        this.entityTypeRegistry = entityTypeRegistry;
        this.bottledButterflies = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledButterfly(i));
                }
            }
        };
        this.bottledCaterpillars = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerBottledCaterpillar(i));
                }
            }
        };
        this.burntButterflyNet = this.deferredRegister.register("butterfly_net_burnt", () -> new Item(new Item.Properties()));
        this.butterflyBannerPattern = this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
        this.butterflyBook = this.deferredRegister.register("butterfly_book", ButterflyBookItem::new);
        this.butterflyEggs = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyEgg(i));
                }
            }
        };
        this.butterflyFeeder = this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)blockRegistry.getButterflyFeeder().get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
        this.butterflyMicroscope = this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)blockRegistry.getButterflyMicroscope().get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
        this.butterflyNets = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyNet(i));
                }
            }
        };
        this.butterflyOrigamiBlack = this.registerButterflyOrigami("butterfly_origami_black", blockRegistry.getButterflyOrigamiBlack());
        this.butterflyOrigamiBlue = this.registerButterflyOrigami("butterfly_origami_blue", blockRegistry.getButterflyOrigamiBlue());
        this.butterflyOrigamiBrown = this.registerButterflyOrigami("butterfly_origami_brown", blockRegistry.getButterflyOrigamiBrown());
        this.butterflyOrigamiCyan = this.registerButterflyOrigami("butterfly_origami_cyan", blockRegistry.getButterflyOrigamiCyan());
        this.butterflyOrigamiGray = this.registerButterflyOrigami("butterfly_origami_gray", blockRegistry.getButterflyOrigamiGray());
        this.butterflyOrigamiGreen = this.registerButterflyOrigami("butterfly_origami_green", blockRegistry.getButterflyOrigamiGreen());
        this.butterflyOrigamiLightBlue = this.registerButterflyOrigami("butterfly_origami_light_blue", blockRegistry.getButterflyOrigamiLightBlue());
        this.butterflyOrigamiLightGray = this.registerButterflyOrigami("butterfly_origami_light_gray", blockRegistry.getButterflyOrigamiLightGray());
        this.butterflyOrigamiLime = this.registerButterflyOrigami("butterfly_origami_lime", blockRegistry.getButterflyOrigamiLime());
        this.butterflyOrigamiMagenta = this.registerButterflyOrigami("butterfly_origami_magenta", blockRegistry.getButterflyOrigamiMagenta());
        this.butterflyOrigamiOrange = this.registerButterflyOrigami("butterfly_origami_orange", blockRegistry.getButterflyOrigamiOrange());
        this.butterflyOrigamiPink = this.registerButterflyOrigami("butterfly_origami_pink", blockRegistry.getButterflyOrigamiPink());
        this.butterflyOrigamiPurple = this.registerButterflyOrigami("butterfly_origami_purple", blockRegistry.getButterflyOrigamiPurple());
        this.butterflyOrigamiRed = this.registerButterflyOrigami("butterfly_origami_red", blockRegistry.getButterflyOrigamiRed());
        this.butterflyOrigamiWhite = this.registerButterflyOrigami("butterfly_origami_white", blockRegistry.getButterflyOrigamiWhite());
        this.butterflyOrigamiYellow = this.registerButterflyOrigami("butterfly_origami_yellow", blockRegistry.getButterflyOrigamiYellow());
        this.butterflyPotterySherd = this.deferredRegister.register("butterfly_pottery_sherd", () -> new Item(new Item.Properties()));
        this.butterflyScrolls = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflyScroll(i));
                }
            }
        };
        this.butterflyGolemSpawnEgg = this.deferredRegister.register("butterfly_golem", () -> new ForgeSpawnEggItem(entityTypeRegistry.getButterflyGolem(), 0x888800, 0x333333, new Item.Properties()));
        this.butterflySpawnEggs = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerButterflySpawnEgg(i));
                }
            }
        };
        this.caterpillars = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillar(i));
                }
            }
        };
        this.caterpillarSpawnEggs = new ArrayList<RegistryObject<Item>>(){
            {
                for (int i = 0; i < ButterflySpeciesList.SPECIES.length; ++i) {
                    this.add(ItemRegistry.this.registerCaterpillarSpawnEgg(i));
                }
            }
        };
        this.emptyButterflyNet = this.deferredRegister.register("butterfly_net", () -> new ButterflyNetItem(this, -1));
        this.infestedApple = this.deferredRegister.register("infested_apple", () -> new Item(new Item.Properties()));
        this.silk = this.deferredRegister.register("silk", () -> new Item(new Item.Properties()));
        this.zhuangziBook = this.deferredRegister.register("butterfly_zhuangzi", ButterflyZhuangziItem::new);
    }

    public List<RegistryObject<Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<RegistryObject<Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public RegistryObject<Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public RegistryObject<Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public RegistryObject<Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public RegistryObject<Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<RegistryObject<Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public RegistryObject<Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflySpeciesList.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public RegistryObject<Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<RegistryObject<Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public RegistryObject<Item> getButterflyOrigamiBlack() {
        return this.butterflyOrigamiBlack;
    }

    public RegistryObject<Item> getButterflyOrigamiBlue() {
        return this.butterflyOrigamiBlue;
    }

    public RegistryObject<Item> getButterflyOrigamiBrown() {
        return this.butterflyOrigamiBrown;
    }

    public RegistryObject<Item> getButterflyOrigamiCyan() {
        return this.butterflyOrigamiCyan;
    }

    public RegistryObject<Item> getButterflyOrigamiGray() {
        return this.butterflyOrigamiGray;
    }

    public RegistryObject<Item> getButterflyOrigamiGreen() {
        return this.butterflyOrigamiGreen;
    }

    public RegistryObject<Item> getButterflyOrigamiLightBlue() {
        return this.butterflyOrigamiLightBlue;
    }

    public RegistryObject<Item> getButterflyOrigamiLightGray() {
        return this.butterflyOrigamiLightGray;
    }

    public RegistryObject<Item> getButterflyOrigamiLime() {
        return this.butterflyOrigamiLime;
    }

    public RegistryObject<Item> getButterflyOrigamiMagenta() {
        return this.butterflyOrigamiMagenta;
    }

    public RegistryObject<Item> getButterflyOrigamiOrange() {
        return this.butterflyOrigamiOrange;
    }

    public RegistryObject<Item> getButterflyOrigamiPink() {
        return this.butterflyOrigamiPink;
    }

    public RegistryObject<Item> getButterflyOrigamiPurple() {
        return this.butterflyOrigamiPurple;
    }

    public RegistryObject<Item> getButterflyOrigamiRed() {
        return this.butterflyOrigamiRed;
    }

    public RegistryObject<Item> getButterflyOrigamiWhite() {
        return this.butterflyOrigamiWhite;
    }

    public RegistryObject<Item> getButterflyOrigamiYellow() {
        return this.butterflyOrigamiYellow;
    }

    public RegistryObject<Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<RegistryObject<Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<RegistryObject<Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public RegistryObject<Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<RegistryObject<Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<RegistryObject<Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public RegistryObject<Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public RegistryObject<Item> getInfestedApple() {
        return this.infestedApple;
    }

    public RegistryObject<Item> getSilk() {
        return this.silk;
    }

    public RegistryObject<Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private RegistryObject<Item> registerButterflyNet(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyNetItem.getRegistryId(butterflyIndex), () -> new ButterflyNetItem(this, butterflyIndex));
    }

    private RegistryObject<Item> registerBottledButterfly(int butterflyIndex) {
        return this.deferredRegister.register(BottledButterflyItem.getRegistryId(butterflyIndex), () -> new BottledButterflyItem(this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private RegistryObject<Item> registerBottledCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(BottledCaterpillarItem.getRegistryId(butterflyIndex), () -> new BottledCaterpillarItem(this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private RegistryObject<Item> registerButterflyEgg(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyEggItem.getRegistryId(butterflyIndex), () -> new ButterflyEggItem(butterflyIndex, new Item.Properties()));
    }

    private RegistryObject<Item> registerButterflyOrigami(String id, RegistryObject<Block> block) {
        return this.deferredRegister.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private RegistryObject<Item> registerButterflyScroll(int butterflyIndex) {
        return this.deferredRegister.register(ButterflyScrollItem.getRegistryId(butterflyIndex), () -> new ButterflyScrollItem(this.entityTypeRegistry, this, butterflyIndex));
    }

    private RegistryObject<Item> registerButterflySpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register(Butterfly.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getButterflies().get(butterflyIndex), 0x880000, 35071, new Item.Properties()));
    }

    private RegistryObject<Item> registerCaterpillar(int butterflyIndex) {
        return this.deferredRegister.register(CaterpillarItem.getRegistryId(butterflyIndex), () -> new CaterpillarItem(Caterpillar.getRegistryId(butterflyIndex)));
    }

    private RegistryObject<Item> registerCaterpillarSpawnEgg(int butterflyIndex) {
        return this.deferredRegister.register(Caterpillar.getRegistryId(butterflyIndex), () -> new ForgeSpawnEggItem((Supplier)this.entityTypeRegistry.getCaterpillars().get(butterflyIndex), 35071, 0x880000, new Item.Properties()));
    }
}

