/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.animal;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflySpeciesList;
import com.bokmcdok.butterflies.world.entity.DebugInfoSupplier;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyEatCropGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyLayEggGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyMatingGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyPollinateFlowerGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyRestGoal;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyWanderGoal;
import com.bokmcdok.butterflies.world.entity.ai.MothWanderGoal;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import java.util.Calendar;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Butterfly
extends Animal
implements DebugInfoSupplier {
    protected static final EntityDataAccessor<Boolean> DATA_IS_FERTILE = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_LANDED = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_NUM_EGGS = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<String> DATA_GOAL_STATE = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final String IS_FERTILE = "is_fertile";
    protected static final String LANDED = "landed";
    protected static final String NUM_EGGS = "num_eggs";
    private static final int TICKS_PER_FLAP = Mth.m_14167_((float)2.4166098f);
    private static final double BUTTERFLY_SPEED = 1.8;
    private ButterflyData data = null;
    private final ResourceLocation texture;
    private final BlockRegistry blockRegistry;

    public static boolean checkButterflySpawnRules(EntityType<? extends Butterfly> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource rng) {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22280_, 1.8).m_22268_(Attributes.f_22279_, 9.0);
    }

    public static String getRegistryId(int butterflyIndex) {
        return ButterflySpeciesList.SPECIES[butterflyIndex];
    }

    public static void spawn(Level level, ResourceLocation location, BlockPos position, Boolean placed) {
        if (level instanceof ServerLevel) {
            Entity entity;
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
            if (entityType != null && (entity = entityType.m_20615_(level)) instanceof Butterfly) {
                Butterfly butterfly = (Butterfly)entity;
                butterfly.m_7678_((double)position.m_123341_() + 0.45, (double)position.m_123342_() + 0.2, (double)position.m_123343_() + 0.5, 0.0f, 0.0f);
                butterfly.m_5618_(butterfly.f_19796_.m_188501_());
                butterfly.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(position), MobSpawnType.NATURAL, null, null);
                if (placed.booleanValue() || butterfly.getData().getOverallLifeSpan() == ButterflyData.Lifespan.IMMORTAL) {
                    butterfly.m_20331_(true);
                    butterfly.m_21530_();
                }
                level.m_7967_((Entity)butterfly);
            }
        } else {
            level.m_6263_(null, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), SoundEvents.f_12318_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private static boolean isScaredOfEverything(LivingEntity entity) {
        return !(entity instanceof Butterfly) && !(entity instanceof Caterpillar) && !(entity instanceof ButterflyEgg) && !(entity instanceof Chrysalis);
    }

    private static boolean isNotScaredOfCats(LivingEntity entity) {
        return !(entity instanceof Butterfly) && !(entity instanceof Caterpillar) && !(entity instanceof ButterflyEgg) && !(entity instanceof Chrysalis) && !(entity instanceof Cat);
    }

    public Butterfly(BlockRegistry blockRegistry, EntityType<? extends Butterfly> entityType, Level level) {
        super(entityType, level);
        Calendar calendar;
        this.blockRegistry = blockRegistry;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_20242_(true);
        String species = ButterflyData.getSpeciesString((LivingEntity)this);
        if (species.contains("christmas") && (calendar = Calendar.getInstance()).get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            species = "christmas_alt";
        }
        this.texture = new ResourceLocation("butterflies", "textures/entity/butterfly/butterfly_" + species + ".png");
        this.m_146762_(-this.getData().butterflyLifespan());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(IS_FERTILE, ((Boolean)this.f_19804_.m_135370_(DATA_IS_FERTILE)).booleanValue());
        tag.m_128379_(LANDED, ((Boolean)this.f_19804_.m_135370_(DATA_LANDED)).booleanValue());
        tag.m_128405_(NUM_EGGS, ((Integer)this.f_19804_.m_135370_(DATA_NUM_EGGS)).intValue());
    }

    public boolean m_142535_(float fallDistance, float blockModifier, @NotNull DamageSource damageSource) {
        return false;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.m_21530_();
        }
        int numEggs = (Integer)ButterfliesConfig.eggLimit.get();
        if (this.f_19796_.m_188500_() < (Double)ButterfliesConfig.doubleEggChance.get()) {
            numEggs *= 2;
        }
        switch (this.getData().eggMultiplier()) {
            case NONE: {
                numEggs = 0;
                break;
            }
            case NORMAL: {
                break;
            }
            case DOUBLE: {
                numEggs *= 2;
            }
        }
        this.setNumEggs(numEggs);
        return super.m_6518_(levelAccessor, difficulty, spawnType, groupData, compoundTag);
    }

    public BlockRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public int getButterflyIndex() {
        return this.getData().butterflyIndex();
    }

    @Override
    public String getDebugInfo() {
        return (String)this.f_19804_.m_135370_(DATA_GOAL_STATE);
    }

    public boolean getIsActive() {
        switch (this.getData().diurnality()) {
            case DIURNAL: {
                return this.m_9236_().m_46461_();
            }
            case NOCTURNAL: {
                return this.m_9236_().m_46462_();
            }
            case CREPUSCULAR: {
                return !this.m_9236_().m_6042_().m_63967_() && this.m_9236_().m_7445_() == 4;
            }
        }
        return true;
    }

    public boolean getIsFertile() {
        return this.getNumEggs() > 0 && (Boolean)this.f_19804_.m_135370_(DATA_IS_FERTILE) != false;
    }

    public boolean getIsLanded() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LANDED);
    }

    public boolean getIsMoth() {
        return this.getData().type() == ButterflyData.ButterflyType.MOTH;
    }

    public int getNumEggs() {
        return (Integer)this.f_19804_.m_135370_(DATA_NUM_EGGS);
    }

    public float getRenderScale() {
        switch (this.getData().size()) {
            case TINY: {
                return 0.15f;
            }
            case SMALL: {
                return 0.25f;
            }
            case LARGE: {
                return 0.45f;
            }
            case HUGE: {
                return 0.55f;
            }
        }
        return 0.35f;
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        ResourceLocation location = this.getData().preferredFlower();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        return stack.m_150930_(item);
    }

    public boolean isValidLandingBlock(BlockState blockState) {
        return this.getData().isValidLandingBlock(blockState);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (this.getData().eggMultiplier() != ButterflyData.EggMultiplier.NONE && this.m_6898_(itemstack)) {
            if (!this.m_9236_().f_46443_ && this.getNumEggs() == 0) {
                this.m_142075_(player, interactionHand, itemstack);
                this.setNumEggs(1);
                return InteractionResult.SUCCESS;
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        if (this.getData().speed() == ButterflyData.Speed.FAST) {
            navigation.m_26517_(1.2);
        }
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    protected boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_(IS_FERTILE)) {
            this.f_19804_.m_135381_(DATA_IS_FERTILE, (Object)tag.m_128471_(IS_FERTILE));
        }
        if (tag.m_128441_(LANDED)) {
            this.f_19804_.m_135381_(DATA_LANDED, (Object)tag.m_128471_(LANDED));
        }
        if (tag.m_128441_(NUM_EGGS)) {
            this.f_19804_.m_135381_(DATA_NUM_EGGS, (Object)tag.m_128451_(NUM_EGGS));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        if (Objects.equals(this.getData().entityId(), "forester")) {
            this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 3.0f, 0.8, 1.33, Butterfly::isNotScaredOfCats));
        } else {
            this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 3.0f, 0.8, 1.33, Butterfly::isScaredOfEverything));
        }
        this.f_21345_.m_25352_(2, (Goal)new ButterflyLayEggGoal(this, 0.8, 8, 8));
        this.f_21345_.m_25352_(2, (Goal)new ButterflyMatingGoal(this, 1.1, 8.0f));
        if (((Boolean)ButterfliesConfig.enablePollination.get()).booleanValue()) {
            switch (this.getData().plantEffect()) {
                case NONE: {
                    break;
                }
                case POLLINATE: {
                    this.f_21345_.m_25352_(4, (Goal)new ButterflyPollinateFlowerGoal(this, 0.8, 8, 8));
                    break;
                }
                case CONSUME: {
                    this.f_21345_.m_25352_(4, (Goal)new ButterflyEatCropGoal(this, 0.8, 8, 8));
                }
            }
        }
        this.f_21345_.m_25352_(6, (Goal)new ButterflyRestGoal(this, 0.8, 8, 8));
        if (this.getData().type() == ButterflyData.ButterflyType.MOTH || Objects.equals(this.getData().entityId(), "heath")) {
            this.f_21345_.m_25352_(8, (Goal)new MothWanderGoal(this, 1.0));
        } else {
            this.f_21345_.m_25352_(8, (Goal)new ButterflyWanderGoal(this, 1.0));
        }
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Butterfly.class, true, target -> {
            if (target instanceof Butterfly) {
                Butterfly butterfly = (Butterfly)target;
                return butterfly.getButterflyIndex() == this.getData().getMateButterflyIndex() && butterfly.getNumEggs() > 0 && !butterfly.getIsFertile();
            }
            return false;
        }));
    }

    public void m_146762_(int age) {
        this.f_146733_ = age;
    }

    public void setIsFertile(boolean isFertile) {
        this.f_19804_.m_135381_(DATA_IS_FERTILE, (Object)isFertile);
    }

    public void setLanded(boolean landed) {
        this.f_19804_.m_135381_(DATA_LANDED, (Object)landed);
        this.m_20242_(!landed);
    }

    public void setNumEggs(int numEggs) {
        this.f_19804_.m_135381_(DATA_NUM_EGGS, (Object)Math.max(0, numEggs));
    }

    public void setGoalState(String goalState) {
        this.f_19804_.m_135381_(DATA_GOAL_STATE, (Object)goalState);
    }

    public void m_6034_(double x, double y, double z) {
        Vec3 delta = new Vec3(x, y, z).m_82546_(this.m_20182_());
        if (delta.m_82556_() <= 1.0 || this.m_20182_().m_82556_() == 0.0) {
            super.m_6034_(x, y, z);
        }
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * Butterfly.m_20150_()) * d0;
    }

    public void useEgg() {
        this.setNumEggs(this.getNumEggs() - 1);
    }

    protected void m_7840_(double yPos, boolean onGround, @NotNull BlockState blockState, @NotNull BlockPos position) {
    }

    protected void m_8024_() {
        super.m_8024_();
        if (((Boolean)ButterfliesConfig.enableLifespan.get()).booleanValue() && this.getData().getOverallLifeSpan() != ButterflyData.Lifespan.IMMORTAL && !this.m_21532_() && this.m_146764_() >= 0 && this.f_19796_.m_216339_(0, 15) == 0) {
            this.m_6074_();
        }
        if (((Boolean)ButterfliesConfig.debugInformation.get()).booleanValue()) {
            WrappedGoal[] runningGoals;
            StringBuilder debugOutput = new StringBuilder();
            for (WrappedGoal goal : runningGoals = (WrappedGoal[])this.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                debugOutput.append(goal.m_26015_());
                debugOutput.append(" / ");
            }
            this.setGoalState(debugOutput.toString());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_FERTILE, (Object)false);
        this.f_19804_.m_135372_(DATA_LANDED, (Object)false);
        this.f_19804_.m_135372_(DATA_NUM_EGGS, (Object)1);
        this.f_19804_.m_135372_(DATA_GOAL_STATE, (Object)"");
    }

    protected void m_7324_(@NotNull Entity otherEntity) {
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getIsActive() && this.getData().butterflySounds()) {
            return new SoundEvent(new ResourceLocation("butterflies", ButterflyData.getSpeciesString((LivingEntity)this)));
        }
        return super.m_7515_();
    }

    protected float m_6121_() {
        return 0.2f;
    }

    protected void m_6138_() {
    }

    public ButterflyData getData() {
        if (this.data == null) {
            this.data = ButterflyData.getButterflyDataForEntity((LivingEntity)this);
        }
        return this.data;
    }
}

