/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.state.ButterflyRenderState;
import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class ButterflyBaseRenderer<T extends Butterfly, M extends EntityModel<ButterflyRenderState>>
extends MobRenderer<T, ButterflyRenderState, M> {
    public ButterflyBaseRenderer(EntityRendererProvider.Context context, M model) {
        super(context, model, 0.2f);
    }

    @NotNull
    public ButterflyRenderState createRenderState() {
        return new ButterflyRenderState();
    }

    public void extractRenderState(@NotNull T entity, @NotNull ButterflyRenderState renderState, float partialTick) {
        super.extractRenderState(entity, (LivingEntityRenderState)renderState, partialTick);
        if (((Boolean)ButterfliesConfig.Server.debugInformation.get()).booleanValue()) {
            renderState.debugInfo = ((Butterfly)entity).getDebugInfo();
        }
        renderState.isLanded = ((Butterfly)entity).getIsLanded();
        renderState.isMoth = ((Butterfly)entity).getIsMoth();
        renderState.landedDirection = ((Butterfly)entity).getLandedDirection();
        renderState.renderScale = ((Butterfly)entity).getRenderScale();
        renderState.texture = ((Butterfly)entity).getTexture();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ButterflyRenderState renderState) {
        return renderState.texture;
    }

    protected void renderDebugInfo(@NotNull ButterflyRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(renderState.debugInfo, poseStack, multiBufferSource, this.entityRenderDispatcher.cameraOrientation(), this.getFont(), packedLightCoordinates);
    }

    protected void rotateIfLanded(@NotNull ButterflyRenderState renderState, @NotNull PoseStack poseStack) {
        if (renderState.isLanded) {
            switch (renderState.landedDirection) {
                case UP: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case NORTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case EAST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case WEST: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    break;
                }
            }
        }
    }

    protected void scale(@NotNull ButterflyRenderState renderState, PoseStack poses) {
        float s = renderState.renderScale;
        poses.scale(s, s, s);
    }
}

