/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.ButterflyModel;
import com.bokmcdok.butterflies.client.renderer.entity.ButterflyBaseRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.state.ButterflyRenderState;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyRenderer
extends ButterflyBaseRenderer<Butterfly, ButterflyModel> {
    public ButterflyRenderer(EntityRendererProvider.Context context) {
        super(context, new ButterflyModel(context.bakeLayer(ButterflyModel.LAYER_LOCATION)));
    }

    public void render(@NotNull ButterflyRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(renderState.debugInfo, poseStack, multiBufferSource, this.entityRenderDispatcher.cameraOrientation(), this.getFont(), packedLightCoordinates);
        poseStack.pushPose();
        this.rotateIfLanded(renderState, poseStack);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        super.render((LivingEntityRenderState)renderState, poseStack, multiBufferSource, packedLightCoordinates);
        poseStack.popPose();
        this.renderDebugInfo(renderState, poseStack, multiBufferSource, packedLightCoordinates);
    }
}

