/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.client.model.CaterpillarModel;
import com.bokmcdok.butterflies.client.renderer.entity.EntityDebugInfoRenderer;
import com.bokmcdok.butterflies.client.renderer.entity.state.CaterpillarRenderState;
import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CaterpillarRenderer
extends MobRenderer<Caterpillar, CaterpillarRenderState, CaterpillarModel> {
    public CaterpillarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CaterpillarModel(context.bakeLayer(CaterpillarModel.LAYER_LOCATION)), 0.05f);
    }

    @NotNull
    public CaterpillarRenderState createRenderState() {
        return new CaterpillarRenderState();
    }

    public void extractRenderState(@NotNull Caterpillar entity, @NotNull CaterpillarRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)renderState, partialTick);
        if (((Boolean)ButterfliesConfig.Server.debugInformation.get()).booleanValue()) {
            renderState.debugInfo = entity.getDebugInfo();
        }
        renderState.surfaceDirection = entity.getSurfaceDirection();
        renderState.renderScale = entity.getRenderScale();
        renderState.texture = entity.getTexture();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CaterpillarRenderState renderState) {
        return renderState.texture;
    }

    protected void scale(@NotNull CaterpillarRenderState renderState, PoseStack poses) {
        float s = renderState.renderScale;
        poses.scale(s, s, s);
    }

    public void render(@NotNull CaterpillarRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLightCoordinates) {
        EntityDebugInfoRenderer.renderDebugInfo(renderState.debugInfo, poseStack, multiBufferSource, this.entityRenderDispatcher.cameraOrientation(), this.getFont(), packedLightCoordinates);
        Direction direction = renderState.surfaceDirection;
        if (direction == Direction.UP) {
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        } else if (direction == Direction.NORTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (direction == Direction.SOUTH) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.WEST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (direction == Direction.EAST) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        super.render((LivingEntityRenderState)renderState, poseStack, multiBufferSource, packedLightCoordinates);
    }
}

