/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.client.renderer.entity;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class EntityDebugInfoRenderer {
    public static <T extends Entity> void renderDebugInfo(String debugInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, Quaternionf cameraOrientation, Font font, int packedLightCoordinates) {
        if (!((Boolean)ButterfliesConfig.Server.debugInformation.get()).booleanValue()) {
            return;
        }
        if (debugInfo.isBlank()) {
            return;
        }
        MutableComponent debugTextComponent = Component.literal((String)debugInfo);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.mulPose(cameraOrientation);
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f poseMatrix = poseStack.last().pose();
        float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        float fontWidthCenter = -font.width((FormattedText)debugTextComponent) / 2;
        font.drawInBatch((Component)debugTextComponent, fontWidthCenter, 0.0f, 0x20FFFFFF, false, poseMatrix, multiBufferSource, Font.DisplayMode.SEE_THROUGH, alpha, packedLightCoordinates);
        font.drawInBatch((Component)debugTextComponent, fontWidthCenter, 0.0f, -1, false, poseMatrix, multiBufferSource, Font.DisplayMode.NORMAL, 0, packedLightCoordinates);
        poseStack.popPose();
    }
}

