/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

public class ForgeEventListener {
    public ForgeEventListener(IEventBus forgeEventBus) {
        forgeEventBus.register((Object)this);
    }

    @SubscribeEvent
    private void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            ForgeEventListener.addToPool(event.getLookupProvider(), ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/plains/houses/plains_butterfly_house_1"), 6);
            ForgeEventListener.addToPool(event.getLookupProvider(), ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/savanna/houses/savanna_butterfly_house_1"), 4);
            ForgeEventListener.addToPool(event.getLookupProvider(), ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"village/taiga/houses/taiga_butterfly_house_1"), 4);
        }
    }

    private static void addToPool(HolderLookup.Provider registryAccess, ResourceLocation structurePool, ResourceLocation structureToAdd, int weight) {
        HolderLookup.RegistryLookup registry = registryAccess.lookupOrThrow(Registries.TEMPLATE_POOL);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)structurePool);
        StructureTemplatePool pool = (StructureTemplatePool)registry.getOrThrow(key).value();
        if (!(pool.rawTemplates instanceof ArrayList)) {
            pool.rawTemplates = new ArrayList(pool.rawTemplates);
        }
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.single((String)structureToAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        pool.rawTemplates.add(Pair.of((Object)addedElement, (Object)weight));
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)addedElement);
        }
    }
}

