/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.event.entity;

import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.entity.animal.Chrysalis;
import com.bokmcdok.butterflies.world.entity.animal.DirectionalCreature;
import java.util.Objects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModEntityEventListener {
    private final EntityTypeRegistry entityTypeRegistry;

    public ModEntityEventListener(IEventBus modEventBus, EntityTypeRegistry entityTypeRegistry) {
        modEventBus.register((Object)this);
        this.entityTypeRegistry = entityTypeRegistry;
    }

    private static boolean isButterflyAttackableByCat(LivingEntity entity) {
        if (entity instanceof Butterfly) {
            Butterfly butterfly = (Butterfly)entity;
            return !Objects.equals(butterfly.getData().entityId(), "forester");
        }
        return false;
    }

    @SubscribeEvent
    private void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getButterflies()) {
            event.put((EntityType)deferredHolder.get(), Butterfly.createAttributes().build());
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getCaterpillars()) {
            event.put((EntityType)deferredHolder.get(), Caterpillar.createAttributes().build());
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getChrysalises()) {
            event.put((EntityType)deferredHolder.get(), Chrysalis.createAttributes().build());
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getButterflyEggs()) {
            event.put((EntityType)deferredHolder.get(), ButterflyEgg.createAttributes().build());
        }
        event.put((EntityType)this.entityTypeRegistry.getButterflyGolem().get(), IronGolem.createAttributes().build());
    }

    @SubscribeEvent
    private void onSpawnPlacementRegister(RegisterSpawnPlacementsEvent event) {
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getButterflies()) {
            event.register((EntityType)deferredHolder.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, Butterfly::checkButterflySpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getCaterpillars()) {
            event.register((EntityType)deferredHolder.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getChrysalises()) {
            event.register((EntityType)deferredHolder.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
        for (DeferredHolder<EntityType<?>, EntityType<? extends Mob>> deferredHolder : this.entityTypeRegistry.getButterflyEggs()) {
            event.register((EntityType)deferredHolder.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, DirectionalCreature::checkDirectionalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        }
        event.register((EntityType)this.entityTypeRegistry.getButterflyGolem().get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }
}

