/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.network.protocol.common.custom;

import com.bokmcdok.butterflies.network.protocol.common.custom.ClientBoundButterflyDataPacket;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.zip.DataFormatException;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientPayloadHandler {
    public static void handleButterflyData(@NotNull ClientBoundButterflyDataPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            ButterflyData.reset();
            List<ButterflyData> butterflyData = data.data();
            ButterflyData.reset();
            for (ButterflyData butterfly : butterflyData) {
                try {
                    ButterflyData.addButterfly(butterfly);
                }
                catch (DataFormatException e) {
                    LogUtils.getLogger().error("Received invalid butterfly data.", (Throwable)e);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"networking.butterflies.data_sync_failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

