/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BlockEntityTypeRegistry;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.bokmcdok.butterflies.registries.MenuTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.block.BottledButterflyBlock;
import com.bokmcdok.butterflies.world.block.BottledCaterpillarBlock;
import com.bokmcdok.butterflies.world.block.ButterflyFeederBlock;
import com.bokmcdok.butterflies.world.block.ButterflyMicroscopeBlock;
import com.bokmcdok.butterflies.world.block.ButterflyOrigamiBlock;
import com.bokmcdok.butterflies.world.block.FlowerCropBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BlockRegistry {
    private static final String BUTTERFLY_MICROSCOPE_ID = "butterfly_microscope";
    private static final String[] ORIGAMI_IDS = new String[]{"butterfly_origami_black", "butterfly_origami_blue", "butterfly_origami_brown", "butterfly_origami_cyan", "butterfly_origami_gray", "butterfly_origami_green", "butterfly_origami_light_blue", "butterfly_origami_light_gray", "butterfly_origami_lime", "butterfly_origami_magenta", "butterfly_origami_orange", "butterfly_origami_pink", "butterfly_origami_purple", "butterfly_origami_red", "butterfly_origami_white", "butterfly_origami_yellow"};
    private final DeferredRegister<Block> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"butterflies");
    private List<DeferredHolder<Block, Block>> bottledButterflyBlocks;
    private List<DeferredHolder<Block, Block>> bottledCaterpillarBlocks;
    private DeferredHolder<Block, Block> butterflyFeeder;
    private DeferredHolder<Block, Block> butterflyMicroscope;
    private DeferredHolder<Block, Block> alliumBud;
    private DeferredHolder<Block, Block> azureBluetBud;
    private DeferredHolder<Block, Block> blueOrchidBud;
    private DeferredHolder<Block, Block> cornflowerBud;
    private DeferredHolder<Block, Block> dandelionBud;
    private DeferredHolder<Block, Block> lilyOfTheValleyBud;
    private DeferredHolder<Block, Block> orangeTulipBud;
    private DeferredHolder<Block, Block> oxeyeDaisyBud;
    private DeferredHolder<Block, Block> pinkTulipBud;
    private DeferredHolder<Block, Block> poppyBud;
    private DeferredHolder<Block, Block> redTulipBud;
    private DeferredHolder<Block, Block> whiteTulipBud;
    private DeferredHolder<Block, Block> witherRoseBud;
    private List<DeferredHolder<Block, Block>> butterflyOrigami;

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos, EntityType<?> ignoredEntityType) {
        return false;
    }

    public static boolean never(BlockState ignoredBlockState, BlockGetter ignoredBlockGetter, BlockPos ignoredBlockPos) {
        return false;
    }

    public BlockRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BlockEntityTypeRegistry blockEntityTypeRegistry, @NotNull DataComponentRegistry dataComponentRegistry, @NotNull ItemRegistry itemRegistry, @NotNull MenuTypeRegistry menuTypeRegistry) {
        int i;
        Objects.requireNonNull(blockEntityTypeRegistry);
        Objects.requireNonNull(dataComponentRegistry);
        Objects.requireNonNull(itemRegistry);
        Objects.requireNonNull(menuTypeRegistry);
        this.bottledButterflyBlocks = new ArrayList<DeferredHolder<Block, Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            DeferredHolder<Block, Block> newBlock = this.registerBottledButterfly(i);
            this.bottledButterflyBlocks.add(newBlock);
        }
        this.bottledCaterpillarBlocks = new ArrayList<DeferredHolder<Block, Block>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.bottledCaterpillarBlocks.add(this.registerBottledCaterpillar(i));
        }
        this.alliumBud = this.registerFlowerCropBlock("bud_allium", Blocks.ALLIUM);
        this.azureBluetBud = this.registerFlowerCropBlock("bud_azure_bluet", Blocks.AZURE_BLUET);
        this.blueOrchidBud = this.registerFlowerCropBlock("bud_blue_orchid", Blocks.BLUE_ORCHID);
        this.cornflowerBud = this.registerFlowerCropBlock("bud_cornflower", Blocks.CORNFLOWER);
        this.dandelionBud = this.registerFlowerCropBlock("bud_dandelion", Blocks.DANDELION);
        this.lilyOfTheValleyBud = this.registerFlowerCropBlock("bud_lily_of_the_valley", Blocks.LILY_OF_THE_VALLEY);
        this.orangeTulipBud = this.registerFlowerCropBlock("bud_orange_tulip", Blocks.ORANGE_TULIP);
        this.oxeyeDaisyBud = this.registerFlowerCropBlock("bud_oxeye_daisy", Blocks.OXEYE_DAISY);
        this.pinkTulipBud = this.registerFlowerCropBlock("bud_pink_tulip", Blocks.PINK_TULIP);
        this.poppyBud = this.registerFlowerCropBlock("bud_poppy", Blocks.POPPY);
        this.redTulipBud = this.registerFlowerCropBlock("bud_red_tulip", Blocks.RED_TULIP);
        this.whiteTulipBud = this.registerFlowerCropBlock("bud_white_tulip", Blocks.WHITE_TULIP);
        this.witherRoseBud = this.registerFlowerCropBlock("bud_wither_rose", Blocks.WITHER_ROSE);
        this.butterflyFeeder = this.registerButterflyFeeder(blockEntityTypeRegistry, menuTypeRegistry);
        this.butterflyMicroscope = this.registerButterflyMicroscope(dataComponentRegistry, itemRegistry, menuTypeRegistry);
        this.butterflyOrigami = new ArrayList<DeferredHolder<Block, Block>>();
        for (String id : ORIGAMI_IDS) {
            this.butterflyOrigami.add(this.registerButterflyOrigami(id));
        }
    }

    public DeferredHolder<Block, Block> getAlliumBud() {
        return this.alliumBud;
    }

    public DeferredHolder<Block, Block> getAzureBluetBud() {
        return this.azureBluetBud;
    }

    public DeferredHolder<Block, Block> getBlueOrchidBud() {
        return this.blueOrchidBud;
    }

    public List<DeferredHolder<Block, Block>> getBottledButterflyBlocks() {
        return this.bottledButterflyBlocks;
    }

    public List<DeferredHolder<Block, Block>> getBottledCaterpillarBlocks() {
        return this.bottledCaterpillarBlocks;
    }

    public DeferredHolder<Block, Block> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public DeferredHolder<Block, Block> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public List<DeferredHolder<Block, Block>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public DeferredHolder<Block, Block> getCornflowerBud() {
        return this.cornflowerBud;
    }

    public DeferredHolder<Block, Block> getDandelionBud() {
        return this.dandelionBud;
    }

    public DeferredHolder<Block, Block> getLilyOfTheValleyBud() {
        return this.lilyOfTheValleyBud;
    }

    public DeferredHolder<Block, Block> getOrangeTulipBud() {
        return this.orangeTulipBud;
    }

    public DeferredHolder<Block, Block> getOxeyeDaisyBud() {
        return this.oxeyeDaisyBud;
    }

    public DeferredHolder<Block, Block> getPinkTulipBud() {
        return this.pinkTulipBud;
    }

    public DeferredHolder<Block, Block> getPoppyBud() {
        return this.poppyBud;
    }

    public DeferredHolder<Block, Block> getRedTulipBud() {
        return this.redTulipBud;
    }

    public DeferredHolder<Block, Block> getWhiteTulipBud() {
        return this.whiteTulipBud;
    }

    public DeferredHolder<Block, Block> getWitherRoseBud() {
        return this.witherRoseBud;
    }

    private String getBottledButterflyRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private String getBottledCaterpillarRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    private DeferredHolder<Block, Block> registerBottledButterfly(int butterflyIndex) {
        String registryId = this.getBottledButterflyRegistryId(butterflyIndex);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)registryId);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f).setId(resourceKey);
        if (Arrays.asList(ButterflyInfo.TRAITS[butterflyIndex]).contains((Object)ButterflyData.Trait.GLOW)) {
            return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(properties.lightLevel(blockState -> 15)));
        }
        return this.deferredRegister.register(registryId, () -> new BottledButterflyBlock(properties));
    }

    private DeferredHolder<Block, Block> registerBottledCaterpillar(int butterflyIndex) {
        String registryId = this.getBottledCaterpillarRegistryId(butterflyIndex);
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.GLASS).strength(0.3f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)registryId)));
        return this.deferredRegister.register(registryId, () -> new BottledCaterpillarBlock(properties));
    }

    private DeferredHolder<Block, Block> registerButterflyFeeder(BlockEntityTypeRegistry blockEntityTypeRegistry, MenuTypeRegistry menuTypeRegistry) {
        BlockBehaviour.Properties properties = ButterflyFeederBlock.PROPERTIES;
        return this.deferredRegister.register("butterfly_feeder", () -> new ButterflyFeederBlock(blockEntityTypeRegistry, menuTypeRegistry, properties));
    }

    private DeferredHolder<Block, Block> registerButterflyMicroscope(DataComponentRegistry dataComponentRegistry, ItemRegistry itemRegistry, MenuTypeRegistry menuTypeRegistry) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).isRedstoneConductor(BlockRegistry::never).isSuffocating(BlockRegistry::never).isValidSpawn(BlockRegistry::never).isViewBlocking(BlockRegistry::never).noOcclusion().sound(SoundType.STONE).strength(1.0f).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)BUTTERFLY_MICROSCOPE_ID)));
        return this.deferredRegister.register(BUTTERFLY_MICROSCOPE_ID, () -> new ButterflyMicroscopeBlock(dataComponentRegistry, itemRegistry, menuTypeRegistry, properties));
    }

    private DeferredHolder<Block, Block> registerButterflyOrigami(String id) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().noCollission().strength(0.5f, 2.5f).sound(SoundType.PINK_PETALS).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)id)));
        return this.deferredRegister.register(id, () -> new ButterflyOrigamiBlock(properties));
    }

    private DeferredHolder<Block, Block> registerFlowerCropBlock(String registryId, Block block) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)registryId)));
        return this.deferredRegister.register(registryId, () -> new FlowerCropBlock(block, properties));
    }
}

