/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.ItemRegistry;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DecoratedPotPatternsRegistry {
    private final DeferredRegister<DecoratedPotPattern> deferredRegister = DeferredRegister.create((ResourceKey)Registries.DECORATED_POT_PATTERN, (String)"butterflies");
    private DeferredHolder<DecoratedPotPattern, DecoratedPotPattern> butterflyPotPattern;
    private final ResourceKey<DecoratedPotPattern> butterflyPotPatternKey;

    public DecoratedPotPatternsRegistry(IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
        this.butterflyPotPatternKey = ResourceKey.create((ResourceKey)Registries.DECORATED_POT_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"butterfly_pottery_pattern"));
    }

    public void initialise() {
        this.butterflyPotPattern = this.deferredRegister.register("butterfly_pottery_pattern", () -> new DecoratedPotPattern(ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)"butterfly_pottery_pattern")));
    }

    public DeferredHolder<DecoratedPotPattern, DecoratedPotPattern> getButterflyPotPattern() {
        return this.butterflyPotPattern;
    }

    public void expandVanillaPatterns(ItemRegistry itemRegistry) {
        ImmutableMap.Builder itemsToPot = new ImmutableMap.Builder();
        itemsToPot.putAll(DecoratedPotPatterns.ITEM_TO_POT_TEXTURE);
        itemsToPot.put((Object)((Item)itemRegistry.getButterflyPotterySherd().get()), this.butterflyPotPatternKey);
        DecoratedPotPatterns.ITEM_TO_POT_TEXTURE = itemsToPot.build();
    }
}

