/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.registries;

import com.bokmcdok.butterflies.registries.BannerPatternRegistry;
import com.bokmcdok.butterflies.registries.BlockRegistry;
import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.registries.EntityTypeRegistry;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import com.bokmcdok.butterflies.world.item.BottledButterflyItem;
import com.bokmcdok.butterflies.world.item.BottledCaterpillarItem;
import com.bokmcdok.butterflies.world.item.ButterflyBookItem;
import com.bokmcdok.butterflies.world.item.ButterflyEggItem;
import com.bokmcdok.butterflies.world.item.ButterflyNetItem;
import com.bokmcdok.butterflies.world.item.ButterflyScrollItem;
import com.bokmcdok.butterflies.world.item.ButterflyZhuangZiItem;
import com.bokmcdok.butterflies.world.item.CaterpillarItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ItemRegistry {
    private final DeferredRegister<Item> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"butterflies");
    private BlockRegistry blockRegistry;
    private DataComponentRegistry dataComponentRegistry;
    private EntityTypeRegistry entityTypeRegistry;
    private DeferredHolder<Item, Item> emptyButterflyNet;
    private List<DeferredHolder<Item, Item>> butterflyNets;
    private DeferredHolder<Item, Item> burntButterflyNet;
    private List<DeferredHolder<Item, Item>> butterflyEggs;
    private List<DeferredHolder<Item, Item>> caterpillars;
    private List<DeferredHolder<Item, Item>> bottledButterflies;
    private List<DeferredHolder<Item, Item>> bottledCaterpillars;
    private List<DeferredHolder<Item, Item>> butterflyScrolls;
    private DeferredHolder<Item, Item> butterflyBook;
    private DeferredHolder<Item, Item> zhuangziBook;
    private DeferredHolder<Item, Item> butterflyFeeder;
    private DeferredHolder<Item, Item> butterflyMicroscope;
    private DeferredHolder<Item, Item> infestedApple;
    private DeferredHolder<Item, Item> silk;
    private List<DeferredHolder<Item, Item>> butterflyOrigami;
    private DeferredHolder<Item, Item> butterflyPotterySherd;
    private DeferredHolder<Item, Item> butterflyBannerPattern;
    private List<DeferredHolder<Item, Item>> eggSpawnEggs;
    private List<DeferredHolder<Item, Item>> chrysalisSpawnEggs;
    private List<DeferredHolder<Item, Item>> caterpillarSpawnEggs;
    private List<DeferredHolder<Item, Item>> butterflySpawnEggs;
    private DeferredHolder<Item, Item> butterflyGolemSpawnEgg;

    public ItemRegistry(@NotNull IEventBus modEventBus) {
        this.deferredRegister.register(modEventBus);
    }

    public void initialise(@NotNull BannerPatternRegistry bannerPatternRegistry, @NotNull BlockRegistry blockRegistry, @NotNull DataComponentRegistry dataComponentRegistry, @NotNull EntityTypeRegistry entityTypeRegistry) {
        int i;
        int i2;
        this.blockRegistry = Objects.requireNonNull(blockRegistry, "blockRegistry cannot be null");
        this.dataComponentRegistry = Objects.requireNonNull(dataComponentRegistry, "dataComponentRegistry cannot be null");
        this.entityTypeRegistry = Objects.requireNonNull(entityTypeRegistry, "entityTypeRegistry cannot be null");
        this.emptyButterflyNet = this.registerButterflyNet(-1, "butterfly_net");
        this.butterflyNets = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyNets.add(this.registerButterflyNet(i2));
        }
        this.burntButterflyNet = this.registerItem("butterfly_net_burnt");
        this.butterflyEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyEggs.add(this.registerButterflyEgg(i2));
        }
        this.caterpillars = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.caterpillars.add(this.registerCaterpillar(i2));
        }
        this.bottledButterflies = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledButterflies.add(this.registerBottledButterfly(i2));
        }
        this.bottledCaterpillars = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.bottledCaterpillars.add(this.registerBottledCaterpillar(i2));
        }
        this.butterflyScrolls = new ArrayList<DeferredHolder<Item, Item>>();
        for (i2 = 0; i2 < ButterflyInfo.SPECIES.length; ++i2) {
            this.butterflyScrolls.add(this.registerButterflyScroll(i2));
        }
        this.butterflyBook = this.registerButterflyBook();
        this.zhuangziBook = this.registerZhuangZiBook();
        this.butterflyFeeder = this.registerButterflyFeeder();
        this.butterflyMicroscope = this.registerButterflyMicroscope();
        this.infestedApple = this.registerItem("infested_apple");
        this.silk = this.registerItem("silk");
        this.butterflyOrigami = new ArrayList<DeferredHolder<Item, Item>>();
        for (DeferredHolder<Block, Block> block : blockRegistry.getButterflyOrigami()) {
            this.butterflyOrigami.add(this.registerButterflyOrigami(block.getId().getPath(), block));
        }
        this.butterflyPotterySherd = this.registerItem("butterfly_pottery_sherd");
        this.butterflyBannerPattern = this.registerBannerPattern(bannerPatternRegistry);
        this.eggSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.eggSpawnEggs.add(this.registerButterflyEggSpawnEgg(i));
        }
        this.chrysalisSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.chrysalisSpawnEggs.add(this.registerChrysalisSpawnEgg(i));
        }
        this.caterpillarSpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.caterpillarSpawnEggs.add(this.registerCaterpillarSpawnEgg(i));
        }
        this.butterflySpawnEggs = new ArrayList<DeferredHolder<Item, Item>>();
        for (i = 0; i < ButterflyInfo.SPECIES.length; ++i) {
            this.butterflySpawnEggs.add(this.registerButterflySpawnEgg(i));
        }
        this.butterflyGolemSpawnEgg = this.registerSpawnEgg("spawn_egg_golem_butterfly", entityTypeRegistry.getButterflyGolem());
    }

    public List<DeferredHolder<Item, Item>> getBottledButterflies() {
        return this.bottledButterflies;
    }

    public List<DeferredHolder<Item, Item>> getBottledCaterpillars() {
        return this.bottledCaterpillars;
    }

    public DeferredHolder<Item, Item> getButterflyBannerPattern() {
        return this.butterflyBannerPattern;
    }

    public DeferredHolder<Item, Item> getButterflyBook() {
        return this.butterflyBook;
    }

    public DeferredHolder<Item, Item> getButterflyMicroscope() {
        return this.butterflyMicroscope;
    }

    public DeferredHolder<Item, Item> getBurntButterflyNet() {
        return this.burntButterflyNet;
    }

    public List<DeferredHolder<Item, Item>> getButterflyEggs() {
        return this.butterflyEggs;
    }

    public DeferredHolder<Item, Item> getButterflyNetFromIndex(int butterflyIndex) {
        if (butterflyIndex < 0) {
            return this.emptyButterflyNet;
        }
        if (Objects.equals(ButterflyInfo.SPECIES[butterflyIndex], "lava")) {
            return this.burntButterflyNet;
        }
        return this.butterflyNets.get(butterflyIndex);
    }

    public DeferredHolder<Item, Item> getButterflyFeeder() {
        return this.butterflyFeeder;
    }

    public List<DeferredHolder<Item, Item>> getButterflyNets() {
        return this.butterflyNets;
    }

    public List<DeferredHolder<Item, Item>> getButterflyOrigami() {
        return this.butterflyOrigami;
    }

    public DeferredHolder<Item, Item> getButterflyPotterySherd() {
        return this.butterflyPotterySherd;
    }

    public List<DeferredHolder<Item, Item>> getButterflyScrolls() {
        return this.butterflyScrolls;
    }

    public List<DeferredHolder<Item, Item>> getButterflySpawnEggs() {
        return this.butterflySpawnEggs;
    }

    public DeferredHolder<Item, Item> getButterflyGolemSpawnEgg() {
        return this.butterflyGolemSpawnEgg;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillars() {
        return this.caterpillars;
    }

    public List<DeferredHolder<Item, Item>> getEggSpawnEggs() {
        return this.eggSpawnEggs;
    }

    public List<DeferredHolder<Item, Item>> getChrysalisSpawnEggs() {
        return this.chrysalisSpawnEggs;
    }

    public List<DeferredHolder<Item, Item>> getCaterpillarSpawnEggs() {
        return this.caterpillarSpawnEggs;
    }

    public DeferredHolder<Item, Item> getEmptyButterflyNet() {
        return this.emptyButterflyNet;
    }

    public DeferredHolder<Item, Item> getInfestedApple() {
        return this.infestedApple;
    }

    public DeferredHolder<Item, Item> getSilk() {
        return this.silk;
    }

    public DeferredHolder<Item, Item> getZhuangziBook() {
        return this.zhuangziBook;
    }

    private ResourceKey<Item> createResourceKey(String registryId) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)registryId);
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }

    private DeferredHolder<Item, Item> registerBannerPattern(BannerPatternRegistry bannerPatternRegistry) {
        String registryId = "banner_pattern_butterfly";
        ResourceKey<Item> key = this.createResourceKey("banner_pattern_butterfly");
        return this.deferredRegister.register("banner_pattern_butterfly", () -> new BannerPatternItem(bannerPatternRegistry.getButterflyBannerPatternTagKey(), new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyBook() {
        ResourceKey<Item> key = this.createResourceKey("butterfly_book");
        return this.deferredRegister.register("butterfly_book", () -> new ButterflyBookItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry));
    }

    private DeferredHolder<Item, Item> registerButterflyFeeder() {
        String registryId = "butterfly_feeder";
        ResourceKey<Item> key = this.createResourceKey("butterfly_feeder");
        return this.deferredRegister.register("butterfly_feeder", () -> new BlockItem((Block)this.blockRegistry.getButterflyFeeder().get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyMicroscope() {
        String registryId = "butterfly_microscope";
        ResourceKey<Item> key = this.createResourceKey("butterfly_microscope");
        return this.deferredRegister.register("butterfly_microscope", () -> new BlockItem((Block)this.blockRegistry.getButterflyMicroscope().get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex) {
        return this.registerButterflyNet(butterflyIndex, ButterflyNetItem.getRegistryId(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyNet(int butterflyIndex, String registryId) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyNetItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry, this, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledButterfly(int butterflyIndex) {
        String registryId = BottledButterflyItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BottledButterflyItem(new Item.Properties().stacksTo(1).setId(key), this.dataComponentRegistry, this.blockRegistry.getBottledButterflyBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerBottledCaterpillar(int butterflyIndex) {
        String registryId = BottledCaterpillarItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BottledCaterpillarItem(new Item.Properties().stacksTo(1).setId(key), this.blockRegistry.getBottledCaterpillarBlocks().get(butterflyIndex), butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflyEgg(int butterflyIndex) {
        String registryId = ButterflyEggItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyEggItem(butterflyIndex, new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyOrigami(String registryId, DeferredHolder<Block, Block> block) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyScroll(int butterflyIndex) {
        String registryId = ButterflyScrollItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyScrollItem(new Item.Properties().setId(key), this.dataComponentRegistry, this.entityTypeRegistry, butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerCaterpillar(int butterflyIndex) {
        String registryId = CaterpillarItem.getRegistryId(butterflyIndex);
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new CaterpillarItem(new Item.Properties().setId(key), Caterpillar.getRegistryId(butterflyIndex)));
    }

    private DeferredHolder<Item, Item> registerItem(String registryId) {
        return this.registerItem(registryId, new Item.Properties());
    }

    private DeferredHolder<Item, Item> registerItem(String registryId, Item.Properties properties) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new Item(properties.setId(key)));
    }

    private DeferredHolder<Item, Item> registerSpawnEgg(String registryId, DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType) {
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new SpawnEggItem((EntityType)entityType.get(), new Item.Properties().setId(key)));
    }

    private DeferredHolder<Item, Item> registerZhuangZiBook() {
        String registryId = "butterfly_zhuangzi";
        ResourceKey<Item> key = this.createResourceKey(registryId);
        return this.deferredRegister.register(registryId, () -> new ButterflyZhuangZiItem(new Item.Properties().stacksTo(1).setId(key)));
    }

    private DeferredHolder<Item, Item> registerButterflyEggSpawnEgg(int butterflyIndex) {
        String registryId = "spawn_egg_egg_" + Butterfly.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getButterflyEggs().get(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerCaterpillarSpawnEgg(int butterflyIndex) {
        String registryId = "spawn_egg_caterpillar_" + Butterfly.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getCaterpillars().get(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerChrysalisSpawnEgg(int butterflyIndex) {
        String registryId = "spawn_egg_chrysalis_" + Butterfly.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getChrysalises().get(butterflyIndex));
    }

    private DeferredHolder<Item, Item> registerButterflySpawnEgg(int butterflyIndex) {
        String registryId = "spawn_egg_butterfly_" + Butterfly.getRegistryId(butterflyIndex);
        return this.registerSpawnEgg(registryId, this.entityTypeRegistry.getButterflies().get(butterflyIndex));
    }
}

