/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ButterflyOrigamiBlock
extends Block {
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private final VoxelShape northAabb;
    private final VoxelShape southAabb;
    private final VoxelShape eastAabb;
    private final VoxelShape westAabb;
    private final VoxelShape upAabb;
    private final VoxelShape downAabb;

    public ButterflyOrigamiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
        this.upAabb = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
        this.downAabb = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        this.northAabb = Block.box((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0);
        this.southAabb = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)4.0);
        this.eastAabb = Block.box((double)0.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0);
        this.westAabb = Block.box((double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos pos) {
        Direction direction = ((FrontAndTop)blockState.getValue(ORIENTATION)).front();
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return levelReader.getBlockState(blockPos).isFaceSturdy((BlockGetter)levelReader, blockPos, direction);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        Direction direction = ((FrontAndTop)blockState.getValue(ORIENTATION)).front();
        return switch (direction) {
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            default -> this.upAabb;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.getClickedFace();
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)(switch (direction) {
            case Direction.NORTH -> FrontAndTop.NORTH_UP;
            case Direction.SOUTH -> FrontAndTop.SOUTH_UP;
            case Direction.EAST -> FrontAndTop.EAST_UP;
            case Direction.WEST -> FrontAndTop.WEST_UP;
            default -> {
                Direction horizontalDirection = blockPlaceContext.getHorizontalDirection();
                switch (horizontalDirection) {
                    case EAST: {
                        yield direction == Direction.UP ? FrontAndTop.UP_EAST : FrontAndTop.DOWN_EAST;
                    }
                    case WEST: {
                        yield direction == Direction.UP ? FrontAndTop.UP_WEST : FrontAndTop.DOWN_WEST;
                    }
                    case SOUTH: {
                        yield direction == Direction.UP ? FrontAndTop.UP_SOUTH : FrontAndTop.DOWN_SOUTH;
                    }
                }
                yield direction == Direction.UP ? FrontAndTop.UP_NORTH : FrontAndTop.DOWN_NORTH;
            }
        }));
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        return direction.getOpposite() == ((FrontAndTop)state.getValue(ORIENTATION)).front() && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{ORIENTATION});
    }
}

