/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public abstract class ButterflyLandOnBlockGoal
extends MoveToBlockGoal {
    protected final Butterfly butterfly;

    public ButterflyLandOnBlockGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange, verticalSearchRange);
        this.butterfly = mob;
    }

    public boolean canContinueToUse() {
        return this.isValidTarget((LevelReader)this.mob.level(), this.blockPos);
    }

    public void stop() {
        this.butterfly.setNotLanded();
        super.stop();
    }

    public void tick() {
        if (this.isReachedTarget()) {
            --this.tryTicks;
            this.mob.getNavigation().stop();
            this.butterfly.setLanded(this.blockPos);
        } else {
            ++this.tryTicks;
            this.butterfly.setNotLanded();
            if (this.shouldRecalculatePath()) {
                this.moveMobToBlock();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Land On Block / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Position = [" + String.valueOf(this.butterfly.blockPosition()) + "] / Reached = [" + this.isReachedTarget() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Direction = [" + String.valueOf(this.butterfly.getLandedDirection()) + "]";
    }

    protected boolean isReachedTarget() {
        BlockPos position;
        Level level = this.butterfly.level();
        if (level.isEmptyBlock(position = this.butterfly.blockPosition())) {
            if (this.isValidTarget((LevelReader)level, position.below())) {
                this.blockPos = position.below();
                this.butterfly.setLandedDirection(Direction.DOWN);
                return true;
            }
            if (this.isValidTarget((LevelReader)level, position.above())) {
                this.blockPos = position.above();
                this.butterfly.setLandedDirection(Direction.UP);
                return true;
            }
            if (this.isValidTarget((LevelReader)level, position.north())) {
                this.blockPos = position.north();
                this.butterfly.setLandedDirection(Direction.NORTH);
                return true;
            }
            if (this.isValidTarget((LevelReader)level, position.south())) {
                this.blockPos = position.south();
                this.butterfly.setLandedDirection(Direction.SOUTH);
                return true;
            }
            if (this.isValidTarget((LevelReader)level, position.east())) {
                this.blockPos = position.east();
                this.butterfly.setLandedDirection(Direction.EAST);
                return true;
            }
            if (this.isValidTarget((LevelReader)level, position.west())) {
                this.blockPos = position.west();
                this.butterfly.setLandedDirection(Direction.WEST);
                return true;
            }
        }
        return false;
    }

    protected boolean isValidTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos) {
        if (this.butterfly.isValidLandingBlock(levelReader.getBlockState(blockPos))) {
            for (Direction d : Direction.values()) {
                if (!levelReader.isEmptyBlock(blockPos.relative(d))) continue;
                return true;
            }
        }
        return false;
    }

    protected void moveMobToBlock() {
        this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, this.speedModifier);
    }
}

