/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.entity.ai;

import com.bokmcdok.butterflies.config.ButterfliesConfig;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.entity.ai.ButterflyLandOnBlockGoal;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ButterflyLayEggGoal
extends ButterflyLandOnBlockGoal {
    public ButterflyLayEggGoal(Butterfly mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
    }

    @Override
    public boolean canContinueToUse() {
        return this.butterfly.getIsActive() && super.canContinueToUse();
    }

    public boolean canUse() {
        return this.butterfly.getIsActive() && this.butterfly.getIsFertile() && super.canUse();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.butterfly.getIsLanded()) {
            this.tryTicks -= 11;
            if (this.butterfly.getIsFertile()) {
                List numButterflies = ButterflyLayEggGoal.getServerLevel((Level)this.butterfly.level()).getNearbyEntities(Butterfly.class, TargetingConditions.forNonCombat(), (LivingEntity)this.butterfly, this.butterfly.getBoundingBox().inflate(32.0));
                int maxDensity = (Integer)ButterfliesConfig.Common.maxDensity.get();
                if (maxDensity == 0 || numButterflies.size() <= maxDensity) {
                    ButterflyData data;
                    Direction direction = this.butterfly.getLandedDirection().getOpposite();
                    if (this.butterfly.level().getBlockState(this.blockPos.relative(direction)).isAir() && (data = ButterflyData.getEntry(this.butterfly.getData().getBaseButterflyIndex())) != null) {
                        ResourceLocation eggEntity = data.getButterflyEggEntity();
                        ButterflyEgg.spawn((ServerLevel)this.butterfly.level(), eggEntity, this.blockPos, direction);
                        this.butterfly.setIsFertile(false);
                        this.butterfly.useEgg();
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "Lay Egg / Target = [" + String.valueOf(this.getMoveToTarget()) + "] / Position = [" + String.valueOf(this.butterfly.blockPosition()) + "] / Reached = [" + this.isReachedTarget() + "] / Landed = [" + this.butterfly.getIsLanded() + "] / Direction = [" + String.valueOf(this.butterfly.getLandedDirection()) + "] / Fertile = [" + this.butterfly.getIsFertile() + "] / Num Eggs = [" + this.butterfly.getNumEggs() + "]";
    }
}

