/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.inventory;

import com.bokmcdok.butterflies.world.inventory.ButterflyFeederSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ButterflyFeederMenu
extends AbstractContainerMenu {
    private final Container feeder;

    public ButterflyFeederMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(1));
    }

    public ButterflyFeederMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, Container container) {
        super(menuType, containerId);
        int i;
        this.feeder = container;
        ButterflyFeederMenu.checkContainerSize((Container)container, (int)1);
        container.startOpen(playerInventory.player);
        this.addSlot(new ButterflyFeederSlot(container, 0, 80, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, i * 18 + 47));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 105));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack item = slot.getItem();
            result = item.copy();
            if (slotIndex < this.feeder.getContainerSize() ? !this.moveItemStackTo(item, this.feeder.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(item, 0, this.feeder.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (item.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.feeder.stopOpen(player);
    }

    public boolean stillValid(@NotNull Player player) {
        return this.feeder.stillValid(player);
    }
}

