/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.registries.DataComponentRegistry;
import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Butterfly;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class BottledButterflyItem
extends BlockItem
implements ButterflyContainerItem {
    public static final String BOTTLED_BUTTERFLY_STRING = "block.butterflies.bottled_butterfly";
    public static final String BOTTLED_MOTH_STRING = "block.butterflies.bottled_moth";
    private final DataComponentRegistry dataComponentRegistry;
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_butterfly_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public BottledButterflyItem(Item.Properties properties, DataComponentRegistry dataComponentRegistry, DeferredHolder<Block, Block> block, int butterflyIndex) {
        super((Block)block.get(), properties);
        this.butterflyIndex = butterflyIndex;
        this.dataComponentRegistry = dataComponentRegistry;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        this.appendButterflyNameToHoverText(this.dataComponentRegistry, stack, tooltipComponents);
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.release_butterfly");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        tooltipComponents.add((Component)newComponent);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && data.type() == ButterflyData.ButterflyType.MOTH) {
            return Component.translatable((String)BOTTLED_MOTH_STRING);
        }
        return Component.translatable((String)BOTTLED_BUTTERFLY_STRING);
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation entity = this.getButterflyEntity(this.dataComponentRegistry, stack);
        if (entity != null) {
            Vec3 lookAngle = player.getLookAngle();
            BlockPos positionToSpawn = player.blockPosition().offset((int)lookAngle.x, (int)lookAngle.y + 1, (int)lookAngle.z);
            Butterfly.spawn(player.level(), entity, positionToSpawn, false);
        }
        ItemStack newItemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        player.setItemInHand(hand, newItemStack);
        return InteractionResult.SUCCESS.heldItemTransformedTo(newItemStack);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        ItemStack stack;
        ResourceLocation entity;
        Player player;
        InteractionResult result = super.place(context);
        if (result == InteractionResult.SUCCESS && (player = context.getPlayer()) != null && (entity = this.getButterflyEntity(this.dataComponentRegistry, stack = player.getItemInHand(context.getHand()))) != null) {
            BlockPos position = context.getClickedPos();
            Butterfly.spawn(player.level(), entity, position, true);
        }
        return result;
    }
}

