/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class BottledCaterpillarItem
extends BlockItem {
    public static final String BOTTLED_CATERPILLAR_STRING = "block.butterflies.bottled_caterpillar";
    public static final String BOTTLED_LARVA_STRING = "block.butterflies.bottled_larva";
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return "bottled_caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public BottledCaterpillarItem(Item.Properties properties, DeferredHolder<Block, Block> block, int butterflyIndex) {
        super((Block)block.get(), properties);
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null) {
            ResourceLocation caterpillarEntity = data.getCaterpillarEntity();
            String translatable = "entity." + caterpillarEntity.toString().replace(':', '.');
            MutableComponent speciesComponent = Component.translatable((String)translatable);
            Style speciesStyle = speciesComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withItalic(Boolean.valueOf(true));
            speciesComponent.setStyle(speciesStyle);
            tooltipComponents.add((Component)speciesComponent);
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.butterflies.release_caterpillar");
            Style tooltipStyle = tooltipComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
            tooltipComponent.setStyle(tooltipStyle);
            tooltipComponents.add((Component)tooltipComponent);
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && data.type() == ButterflyData.ButterflyType.MOTH) {
            return Component.translatable((String)BOTTLED_LARVA_STRING);
        }
        return Component.translatable((String)BOTTLED_CATERPILLAR_STRING);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        Level level;
        InteractionResult result = super.place(context);
        if (result == InteractionResult.SUCCESS && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
            if (data != null) {
                ResourceLocation entity = data.getCaterpillarEntity();
                BlockPos position = context.getClickedPos();
                Caterpillar.spawn(serverLevel, entity, position, Direction.DOWN, true);
            }
        }
        return result;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Optional caterpillarItem;
        ResourceLocation location;
        ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
        if (data != null && (location = data.getCaterpillarItem()) != null && (caterpillarItem = BuiltInRegistries.ITEM.get(location)).isPresent()) {
            ItemStack caterpillarStack = new ItemStack((Holder)caterpillarItem.get(), 1);
            player.addItem(caterpillarStack);
            ItemStack newItemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            player.setItemInHand(hand, newItemStack);
            return InteractionResult.SUCCESS.heldItemTransformedTo(newItemStack);
        }
        return InteractionResult.FAIL;
    }
}

