/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.ButterflyEgg;
import com.bokmcdok.butterflies.world.item.ButterflyContainerItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import org.jetbrains.annotations.NotNull;

public class ButterflyEggItem
extends Item
implements ButterflyContainerItem {
    private final int butterflyIndex;

    public static String getRegistryId(int butterflyIndex) {
        return ButterflyInfo.SPECIES[butterflyIndex] + "_egg";
    }

    public ButterflyEggItem(int butterflyIndex, Item.Properties properties) {
        super(properties);
        this.butterflyIndex = butterflyIndex;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.place_egg");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, context, components, tooltipFlag);
    }

    @Override
    public int getButterflyIndex() {
        return this.butterflyIndex;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            BlockPos clickedPos = context.getClickedPos();
            Block block = context.getLevel().getBlockState(clickedPos).getBlock();
            if (!(block instanceof LeavesBlock)) {
                return InteractionResult.FAIL;
            }
            if (!context.getLevel().isClientSide()) {
                Direction clickedFace = context.getClickedFace();
                ButterflyData data = ButterflyData.getEntry(this.butterflyIndex);
                if (data != null) {
                    ResourceLocation eggEntity = data.getButterflyEggEntity();
                    ButterflyEgg.spawn((ServerLevel)context.getLevel(), eggEntity, clickedPos.relative(clickedFace), clickedFace.getOpposite());
                }
            } else {
                player.playSound(SoundEvents.SLIME_SQUISH_SMALL, 1.0f, 1.0f);
            }
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }
}

