/*
 * Decompiled with CFR 0.152.
 */
package com.bokmcdok.butterflies.world.item;

import com.bokmcdok.butterflies.world.ButterflyData;
import com.bokmcdok.butterflies.world.ButterflyInfo;
import com.bokmcdok.butterflies.world.entity.animal.Caterpillar;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CaterpillarItem
extends Item {
    private final ResourceLocation species;

    public static String getRegistryId(int butterflyIndex) {
        return "caterpillar_" + ButterflyInfo.SPECIES[butterflyIndex];
    }

    public CaterpillarItem(Item.Properties properties, String species) {
        super(properties);
        this.species = ResourceLocation.fromNamespaceAndPath((String)"butterflies", (String)species);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent newComponent = Component.translatable((String)"tooltip.butterflies.place_caterpillar");
        Style style = newComponent.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true));
        newComponent.setStyle(style);
        components.add((Component)newComponent);
        super.appendHoverText(stack, context, components, tooltipFlag);
    }

    @NotNull
    public Component getName(@NotNull ItemStack itemStack) {
        return Component.translatable((String)("entity." + this.species.toString().replace(":", ".")));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            BlockPos clickedPos = context.getClickedPos();
            BlockState blockState = context.getLevel().getBlockState(clickedPos);
            if (!ButterflyData.getEntry(this.species).isValidLandingBlock(blockState)) {
                return InteractionResult.FAIL;
            }
            if (!context.getLevel().isClientSide()) {
                Direction clickedFace = context.getClickedFace();
                Caterpillar.spawn((ServerLevel)context.getLevel(), this.species, clickedPos.relative(clickedFace), clickedFace.getOpposite(), false);
            } else {
                player.playSound(SoundEvents.SLIME_SQUISH_SMALL, 1.0f, 1.0f);
            }
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }
}

