/*
 * Decompiled with CFR 0.152.
 */
package com.linearpast.ae2allinone.compat.mekanism.cells;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import com.linearpast.ae2allinone.compat.mekanism.item.AllChemicalCell;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class AllChemicalStorageCell
implements StorageCell {
    private static final List<ChemicalStack<?>> chemicals = new ArrayList();
    private Object2LongMap<AEKey> storedAmounts;

    public static AllChemicalStorageCell createInventory(ItemStack o) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        if (!(o.m_41720_() instanceof AllChemicalCell)) {
            return null;
        }
        return new AllChemicalStorageCell();
    }

    public CellState getStatus() {
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.m_237119_();
    }

    public static void loadAllChemicals() {
        chemicals.clear();
        try {
            MekanismAPI.gasRegistry().getValues().forEach(gas -> {
                try {
                    if (!gas.isEmptyType()) {
                        chemicals.add((ChemicalStack<?>)new GasStack((IGasProvider)gas, 1L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            MekanismAPI.infuseTypeRegistry().getValues().forEach(infuseType -> {
                try {
                    if (!infuseType.isEmptyType()) {
                        chemicals.add((ChemicalStack<?>)new InfusionStack((IInfuseTypeProvider)infuseType, 1L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            MekanismAPI.pigmentRegistry().getValues().forEach(pigment -> {
                try {
                    if (!pigment.isEmptyType()) {
                        chemicals.add((ChemicalStack<?>)new PigmentStack((IPigmentProvider)pigment, 1L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            MekanismAPI.slurryRegistry().getValues().forEach(slurry -> {
                try {
                    if (!slurry.isEmptyType()) {
                        chemicals.add((ChemicalStack<?>)new SlurryStack((ISlurryProvider)slurry, 1L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCellChemicals() {
        chemicals.forEach(chemicalStack -> {
            try {
                MekanismKey key = MekanismKey.of((ChemicalStack)chemicalStack);
                if (key != null) {
                    this.storedAmounts.put((Object)key, 2147483647000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    protected Object2LongMap<AEKey> getCellChemicals() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellChemicals();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellChemicals().object2LongEntrySet()) {
            try {
                out.add((AEKey)entry.getKey(), entry.getLongValue());
            }
            catch (Exception exception) {}
        }
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return amount;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return false;
    }
}

