/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.ae2allinone.cells;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import com.lirxowo.ae2allinone.item.AllFluidCell;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class AIOFluidStorageCell
implements StorageCell {
    private static final Set<Fluid> fluids = new LinkedHashSet<Fluid>();
    private Object2LongMap<AEKey> storedAmounts;

    @Nullable
    public static AIOFluidStorageCell createInventory(ItemStack o) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        if (!(o.getItem() instanceof AllFluidCell)) {
            return null;
        }
        return new AIOFluidStorageCell();
    }

    public CellState getStatus() {
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.empty();
    }

    public static void loadAllFluids() {
        fluids.clear();
        BuiltInRegistries.FLUID.forEach(fluid -> {
            try {
                if (fluid == Fluids.EMPTY) {
                    return;
                }
                if (fluid.isSource(fluid.defaultFluidState())) {
                    fluids.add((Fluid)fluid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void loadCellFluids() {
        fluids.forEach(fluid -> {
            AEFluidKey aeFluidKey = AEFluidKey.of((Fluid)fluid);
            if (aeFluidKey != null) {
                this.storedAmounts.put((Object)aeFluidKey, 2147483647000L);
            }
        });
    }

    protected Object2LongMap<AEKey> getCellFluids() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellFluids();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellFluids().object2LongEntrySet()) {
            try {
                out.add((AEKey)entry.getKey(), entry.getLongValue());
            }
            catch (Exception exception) {}
        }
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return amount;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        return 0L;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return false;
    }
}

