/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.ae2allinone.cells;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import com.lirxowo.ae2allinone.item.AllFluidCell;
import com.lirxowo.ae2allinone.item.AllItemCell;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.GameMasterBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import org.jetbrains.annotations.Nullable;

public class AIOStorageCell
implements StorageCell {
    private static final Set<ItemStack> items = new LinkedHashSet<ItemStack>();
    private Object2LongMap<AEKey> storedAmounts;

    @Nullable
    public static AIOStorageCell createInventory(ItemStack o) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        if (!(o.getItem() instanceof AllItemCell)) {
            return null;
        }
        return new AIOStorageCell();
    }

    public CellState getStatus() {
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.empty();
    }

    public static void loadAllItems() {
        items.clear();
        BuiltInRegistries.ITEM.forEach(item -> {
            try {
                if (item instanceof GameMasterBlockItem) {
                    return;
                }
                if (item instanceof AllItemCell) {
                    return;
                }
                if (item instanceof AllFluidCell) {
                    return;
                }
                if (item instanceof SpawnEggItem) {
                    return;
                }
                ItemStack stack = item.getDefaultInstance();
                items.add(stack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void loadCellItems() {
        items.stream().map(AEItemKey::of).forEach(aeItemKey -> {
            if (aeItemKey != null) {
                this.storedAmounts.put(aeItemKey, Integer.MAX_VALUE);
            }
        });
    }

    protected Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellItems().object2LongEntrySet()) {
            try {
                out.add((AEKey)entry.getKey(), entry.getLongValue());
            }
            catch (Exception exception) {}
        }
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return amount;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        return 0L;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return false;
    }
}

