/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.ae2allinone.compat.mekanism.cells;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import com.lirxowo.ae2allinone.compat.mekanism.item.AllChemicalCell;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AllChemicalStorageCell
implements StorageCell {
    private static final List<ChemicalStack> chemicals = new ArrayList<ChemicalStack>();
    private Object2LongMap<AEKey> storedAmounts;

    @Nullable
    public static AllChemicalStorageCell createInventory(ItemStack o) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        if (!(o.getItem() instanceof AllChemicalCell)) {
            return null;
        }
        return new AllChemicalStorageCell();
    }

    public CellState getStatus() {
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.empty();
    }

    public static void loadAllChemicals() {
        chemicals.clear();
        try {
            MekanismAPI.CHEMICAL_REGISTRY.holders().forEach(holder -> {
                try {
                    if (!holder.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                        chemicals.add(new ChemicalStack((Holder)holder, 1L));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCellChemicals() {
        chemicals.forEach(chemicalStack -> {
            try {
                MekanismKey key = MekanismKey.of((ChemicalStack)chemicalStack);
                if (key != null) {
                    this.storedAmounts.put((Object)key, 2147483647000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    protected Object2LongMap<AEKey> getCellChemicals() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellChemicals();
        }
        return this.storedAmounts;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellChemicals().object2LongEntrySet()) {
            try {
                out.add((AEKey)entry.getKey(), entry.getLongValue());
            }
            catch (Exception exception) {}
        }
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return amount;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        return 0L;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return false;
    }
}

