/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.ae2allinone.datagen;

import com.lirxowo.ae2allinone.Ae2allinone;
import com.lirxowo.ae2allinone.compat.mekanism.MekanismItems;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModItemModelProvider
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ae2allinone", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(Ae2allinone.ITEMS.getEntries());
        if (MekanismItems.isRegistered()) {
            items.addAll(MekanismItems.ITEMS.getEntries());
        }
        items.forEach(item -> this.itemGenerateModel((Item)item.get(), this.resourceItem((DeferredHolder<Item, ? extends Item>)item)));
    }

    public void itemGenerateModel(Item item, ResourceLocation location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", location);
    }

    public String itemName(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath();
    }

    public ResourceLocation resourceItem(DeferredHolder<Item, ? extends Item> item) {
        String prefix = "item/";
        if (item.getId() != null) {
            return ResourceLocation.fromNamespaceAndPath((String)"ae2allinone", (String)(prefix + item.getId().getPath()));
        }
        throw new IllegalArgumentException("Unknown item id.");
    }
}

