/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.api;

import java.io.File;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.configuration.Messages;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.ReadDatabaseProvider;
import xyz.kyngs.librelogin.api.database.ReadDatabaseProviderRegistration;
import xyz.kyngs.librelogin.api.database.ReadWriteDatabaseProvider;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.WriteDatabaseProvider;
import xyz.kyngs.librelogin.api.database.connector.DatabaseConnector;
import xyz.kyngs.librelogin.api.event.EventProvider;
import xyz.kyngs.librelogin.api.event.EventTypes;
import xyz.kyngs.librelogin.api.image.ImageProjector;
import xyz.kyngs.librelogin.api.integration.LimboIntegration;
import xyz.kyngs.librelogin.api.mail.EmailHandler;
import xyz.kyngs.librelogin.api.premium.PremiumProvider;
import xyz.kyngs.librelogin.api.server.ServerHandler;
import xyz.kyngs.librelogin.api.totp.TOTPProvider;
import xyz.kyngs.librelogin.api.util.SemanticVersion;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public interface LibreLoginPlugin<P, S> {
    public PremiumProvider getPremiumProvider();

    public Logger getLogger();

    public InputStream getResourceAsStream(String var1);

    public AuthorizationProvider<P> getAuthorizationProvider();

    public EventProvider<P, S> getEventProvider();

    public Messages getMessages();

    public CryptoProvider getCryptoProvider(String var1);

    public CryptoProvider getDefaultCryptoProvider();

    public ReadWriteDatabaseProvider getDatabaseProvider();

    public TOTPProvider getTOTPProvider();

    public ImageProjector<P> getImageProjector();

    public void migrate(ReadDatabaseProvider var1, WriteDatabaseProvider var2);

    public Map<String, ReadDatabaseProviderRegistration<?, ?, ?>> getReadProviders();

    public void registerReadProvider(ReadDatabaseProviderRegistration<?, ?, ?> var1);

    public void registerCryptoProvider(CryptoProvider var1);

    public <E extends Exception, C extends DatabaseConnector<E, ?>> void registerDatabaseConnector(Class<?> var1, ThrowableFunction<String, C, E> var2, String var3);

    public File getDataFolder();

    public void checkDataFolder();

    public String getVersion();

    public SemanticVersion getParsedVersion();

    public boolean isPresent(UUID var1);

    public boolean multiProxyEnabled();

    public boolean validPassword(String var1);

    public P getPlayerForUUID(UUID var1);

    public PlatformHandle<P, S> getPlatformHandle();

    public ServerHandler<P, S> getServerHandler();

    @Nullable
    public EmailHandler getEmailHandler();

    @Nullable
    public LimboIntegration<S> getLimboIntegration();

    default public EventTypes<P, S> getEventTypes() {
        return this.getEventProvider().getTypes();
    }

    public User createUser(UUID var1, UUID var2, HashedPassword var3, String var4, Timestamp var5, Timestamp var6, String var7, String var8, Timestamp var9, String var10, String var11);
}

