/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.api.util;

public record SemanticVersion(int major, int minor, int patch, boolean dev) {
    public static SemanticVersion parse(String version) {
        String[] split = version.replace("-SNAPSHOT", "").split("\\.");
        return new SemanticVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), version.endsWith("-SNAPSHOT"));
    }

    public int compare(SemanticVersion other) {
        if (this.major != other.major) {
            return this.major < other.major ? -1 : 1;
        }
        if (this.minor != other.minor) {
            return this.minor < other.minor ? -1 : 1;
        }
        if (this.patch != other.patch) {
            return this.patch < other.patch ? -1 : 1;
        }
        return this.dev ? (other.dev ? 0 : -1) : (other.dev ? 1 : 0);
    }

    @Override
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.dev ? "-SNAPSHOT" : "");
    }
}

