/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common;

import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.ReadDatabaseProvider;
import xyz.kyngs.librelogin.api.database.ReadDatabaseProviderRegistration;
import xyz.kyngs.librelogin.api.database.ReadWriteDatabaseProvider;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.WriteDatabaseProvider;
import xyz.kyngs.librelogin.api.database.connector.DatabaseConnector;
import xyz.kyngs.librelogin.api.database.connector.MySQLDatabaseConnector;
import xyz.kyngs.librelogin.api.database.connector.PostgreSQLDatabaseConnector;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.api.database.connector.SQLiteDatabaseConnector;
import xyz.kyngs.librelogin.api.integration.LimboIntegration;
import xyz.kyngs.librelogin.api.premium.PremiumException;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.api.server.ServerHandler;
import xyz.kyngs.librelogin.api.totp.TOTPProvider;
import xyz.kyngs.librelogin.api.util.Release;
import xyz.kyngs.librelogin.api.util.SemanticVersion;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.CommandProvider;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.HoconMessages;
import xyz.kyngs.librelogin.common.config.HoconPluginConfiguration;
import xyz.kyngs.librelogin.common.config.NewUUIDCreator;
import xyz.kyngs.librelogin.common.crypto.Argon2IDCryptoProvider;
import xyz.kyngs.librelogin.common.crypto.BCrypt2ACryptoProvider;
import xyz.kyngs.librelogin.common.crypto.LogITMessageDigestCryptoProvider;
import xyz.kyngs.librelogin.common.crypto.MessageDigestCryptoProvider;
import xyz.kyngs.librelogin.common.database.AuthenticDatabaseProvider;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.database.connector.AuthenticMySQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.connector.AuthenticPostgreSQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.connector.AuthenticSQLiteDatabaseConnector;
import xyz.kyngs.librelogin.common.database.connector.DatabaseConnectorRegistration;
import xyz.kyngs.librelogin.common.database.provider.LibreLoginMySQLDatabaseProvider;
import xyz.kyngs.librelogin.common.database.provider.LibreLoginPostgreSQLDatabaseProvider;
import xyz.kyngs.librelogin.common.database.provider.LibreLoginSQLiteDatabaseProvider;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.image.AuthenticImageProjector;
import xyz.kyngs.librelogin.common.integration.FloodgateIntegration;
import xyz.kyngs.librelogin.common.integration.luckperms.LuckPermsIntegration;
import xyz.kyngs.librelogin.common.listener.LoginTryListener;
import xyz.kyngs.librelogin.common.log.Log4JFilter;
import xyz.kyngs.librelogin.common.log.SimpleLogFilter;
import xyz.kyngs.librelogin.common.mail.AuthenticEMailHandler;
import xyz.kyngs.librelogin.common.migrate.AegisSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.AuthMeSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.AuthySQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.DBASQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.FastLoginSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.JPremiumSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.LimboAuthSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.LogItSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.LoginSecuritySQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.NLoginSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.migrate.UniqueCodeAuthSQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.premium.AuthenticPremiumProvider;
import xyz.kyngs.librelogin.common.server.AuthenticServerHandler;
import xyz.kyngs.librelogin.common.totp.AuthenticTOTPProvider;
import xyz.kyngs.librelogin.common.util.CancellableTask;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.metrics.charts.CustomChart;

public abstract class AuthenticLibreLogin<P, S>
implements LibreLoginPlugin<P, S> {
    public static final Gson GSON = new Gson();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd. MM. yyyy HH:mm");
    public static final ExecutorService EXECUTOR = new ForkJoinPool(4);
    private final Map<String, CryptoProvider> cryptoProviders = new ConcurrentHashMap<String, CryptoProvider>();
    private final Map<String, ReadDatabaseProviderRegistration<?, ?, ?>> readProviders = new ConcurrentHashMap();
    private final Map<Class<?>, DatabaseConnectorRegistration<?, ?>> databaseConnectors = new ConcurrentHashMap();
    private final Multimap<P, CancellableTask> cancelOnExit;
    private final PlatformHandle<P, S> platformHandle = this.providePlatformHandle();
    private final Set<String> forbiddenPasswords = new HashSet<String>();
    protected xyz.kyngs.librelogin.api.Logger logger;
    private AuthenticPremiumProvider premiumProvider;
    private AuthenticEventProvider<P, S> eventProvider;
    private AuthenticServerHandler<P, S> serverHandler;
    private TOTPProvider totpProvider;
    private AuthenticImageProjector<P, S> imageProjector;
    private FloodgateIntegration floodgateApi;
    private LuckPermsIntegration<P, S> luckpermsApi;
    private SemanticVersion version;
    private HoconPluginConfiguration configuration;
    private HoconMessages messages;
    private AuthenticAuthorizationProvider<P, S> authorizationProvider;
    private CommandProvider<P, S> commandProvider;
    private ReadWriteDatabaseProvider databaseProvider;
    private DatabaseConnector<?, ?> databaseConnector;
    private AuthenticEMailHandler eMailHandler;
    private LoginTryListener<P, S> loginTryListener;

    protected AuthenticLibreLogin() {
        this.cancelOnExit = HashMultimap.create();
    }

    public Map<Class<?>, DatabaseConnectorRegistration<?, ?>> getDatabaseConnectors() {
        return this.databaseConnectors;
    }

    @Override
    public <E extends Exception, C extends DatabaseConnector<E, ?>> void registerDatabaseConnector(Class<?> clazz, ThrowableFunction<String, C, E> factory, String id) {
        this.registerDatabaseConnector(new DatabaseConnectorRegistration<E, C>(factory, null, id), clazz);
    }

    @Override
    public void registerReadProvider(ReadDatabaseProviderRegistration<?, ?, ?> registration) {
        this.readProviders.put(registration.id(), registration);
    }

    @Override
    public AuthenticEMailHandler getEmailHandler() {
        return this.eMailHandler;
    }

    @Override
    @Nullable
    public LimboIntegration<S> getLimboIntegration() {
        return null;
    }

    @Override
    public User createUser(UUID uuid, UUID premiumUUID, HashedPassword hashedPassword, String lastNickname, Timestamp joinDate, Timestamp lastSeen, String secret, String ip, Timestamp lastAuthentication, String lastServer, String email) {
        return new AuthenticUser(uuid, premiumUUID, hashedPassword, lastNickname, joinDate, lastSeen, secret, ip, lastAuthentication, lastServer, email);
    }

    public void registerDatabaseConnector(DatabaseConnectorRegistration<?, ?> registration, Class<?> clazz) {
        this.databaseConnectors.put(clazz, registration);
    }

    @Override
    public PlatformHandle<P, S> getPlatformHandle() {
        return this.platformHandle;
    }

    protected abstract PlatformHandle<P, S> providePlatformHandle();

    @Override
    public SemanticVersion getParsedVersion() {
        return this.version;
    }

    @Override
    public boolean validPassword(String password) {
        boolean length;
        boolean bl = length = password.length() >= this.configuration.get(ConfigurationKeys.MINIMUM_PASSWORD_LENGTH);
        if (!length) {
            return false;
        }
        String upper = password.toUpperCase();
        return !this.forbiddenPasswords.contains(upper);
    }

    @Override
    public Map<String, ReadDatabaseProviderRegistration<?, ?, ?>> getReadProviders() {
        return Map.copyOf(this.readProviders);
    }

    public CommandProvider<P, S> getCommandProvider() {
        return this.commandProvider;
    }

    @Override
    public ReadWriteDatabaseProvider getDatabaseProvider() {
        return this.databaseProvider;
    }

    @Override
    public AuthenticPremiumProvider getPremiumProvider() {
        return this.premiumProvider;
    }

    @Override
    public TOTPProvider getTOTPProvider() {
        return this.totpProvider;
    }

    public AuthenticImageProjector<P, S> getImageProjector() {
        return this.imageProjector;
    }

    @Override
    public ServerHandler<P, S> getServerHandler() {
        return this.serverHandler;
    }

    protected void enable() {
        File oldFolder2;
        block18: {
            this.version = SemanticVersion.parse(this.getVersion());
            if (this.logger == null) {
                this.logger = this.provideLogger();
            }
            try {
                new Log4JFilter().inject();
            }
            catch (Throwable ignored) {
                this.logger.info("LogFilter is not supported on this platform");
                Logger simpleLogger = this.getSimpleLogger();
                if (simpleLogger == null) break block18;
                this.logger.info("Using SimpleLogFilter");
                new SimpleLogFilter(simpleLogger).inject();
            }
        }
        File folder = this.getDataFolder();
        if (!folder.exists() && (oldFolder2 = new File(folder.getParentFile(), folder.getName().equals("librelogin") ? "librepremium" : "LibrePremium")).exists()) {
            this.logger.info("Migrating configuration and messages from old folder...");
            if (!oldFolder2.renameTo(folder)) {
                throw new RuntimeException("Can't migrate configuration and messages from old folder!");
            }
        }
        try {
            Files.copy(this.getResourceAsStream("LICENSE.txt"), new File(folder, "LICENSE.txt").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException oldFolder2) {
            // empty catch block
        }
        if (this.platformHandle.getPlatformIdentifier().equals("paper")) {
            ConfigurationKeys.LIMBO.setDefault(List.of("limbo"));
            HashMultimap lobby = HashMultimap.create();
            lobby.put((Object)"root", (Object)"world");
            ConfigurationKeys.LOBBY.setDefault((Multimap<String, String>)lobby);
        }
        this.eventProvider = new AuthenticEventProvider(this);
        this.premiumProvider = new AuthenticPremiumProvider(this);
        this.registerCryptoProvider(new MessageDigestCryptoProvider("SHA-256"));
        this.registerCryptoProvider(new MessageDigestCryptoProvider("SHA-512"));
        this.registerCryptoProvider(new BCrypt2ACryptoProvider());
        this.registerCryptoProvider(new Argon2IDCryptoProvider(this.logger));
        this.registerCryptoProvider(new LogITMessageDigestCryptoProvider("LOGIT-SHA-256", "SHA-256"));
        this.setupDB();
        this.checkDataFolder();
        this.loadConfigs();
        this.logger.info("Loading forbidden passwords...");
        try {
            this.loadForbiddenPasswords();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("An unknown exception occurred while attempting to load the forbidden passwords, this most likely isn't your fault");
            this.shutdownProxy(1);
        }
        this.logger.info("Loaded %s forbidden passwords".formatted(this.forbiddenPasswords.size()));
        this.connectToDB();
        this.serverHandler = new AuthenticServerHandler(this);
        this.loginTryListener = new LoginTryListener(this);
        GeneralUtil.checkAndMigrate(this.configuration, this.logger, this);
        this.imageProjector = this.provideImageProjector();
        if (this.imageProjector != null) {
            if (!this.configuration.get(ConfigurationKeys.TOTP_ENABLED).booleanValue()) {
                this.imageProjector = null;
                this.logger.warn("2FA is disabled in the configuration, aborting...");
            } else {
                this.imageProjector.enable();
            }
        }
        this.totpProvider = this.imageProjector == null ? null : new AuthenticTOTPProvider(this);
        this.eMailHandler = this.configuration.get(ConfigurationKeys.MAIL_ENABLED) != false ? new AuthenticEMailHandler(this) : null;
        this.authorizationProvider = new AuthenticAuthorizationProvider(this);
        this.commandProvider = new CommandProvider(this);
        if (this.version.dev()) {
            this.logger.warn("!! YOU ARE RUNNING A DEVELOPMENT BUILD OF LIBRELOGIN !!");
            this.logger.warn("!! THIS IS NOT A RELEASE, USE THIS ONLY IF YOU WERE INSTRUCTED TO DO SO. DO NOT USE THIS IN PRODUCTION !!");
        } else {
            this.initMetrics(new CustomChart[0]);
        }
        this.delay(this::checkForUpdates, 1000L);
        if (this.pluginPresent("floodgate")) {
            this.logger.info("Floodgate detected, enabling bedrock support...");
            this.floodgateApi = new FloodgateIntegration();
        }
        if (this.pluginPresent("luckperms")) {
            this.logger.info("LuckPerms detected, enabling context provider");
            this.luckpermsApi = new LuckPermsIntegration(this);
        }
        if (this.multiProxyEnabled()) {
            this.logger.info("Detected MultiProxy setup, enabling MultiProxy support...");
        }
    }

    public <C extends DatabaseConnector<?, ?>> DatabaseConnectorRegistration<?, C> getDatabaseConnector(Class<C> clazz) {
        return this.databaseConnectors.get(clazz);
    }

    private void connectToDB() {
        Object cause;
        this.logger.info("Connecting to the database...");
        try {
            Object provider;
            ReadDatabaseProviderRegistration<?, ?, ?> registration = this.readProviders.get(this.configuration.get(ConfigurationKeys.DATABASE_TYPE));
            if (registration == null) {
                this.logger.error("Database type %s doesn't exist, please check your configuration".formatted(this.configuration.get(ConfigurationKeys.DATABASE_TYPE)));
                this.shutdownProxy(1);
            }
            DatabaseConnector connector = null;
            if (registration.databaseConnector() != null) {
                DatabaseConnectorRegistration<?, ?> connectorRegistration = this.getDatabaseConnector(registration.databaseConnector());
                if (connectorRegistration == null) {
                    this.logger.error("Database type %s is corrupted, please use a different one".formatted(this.configuration.get(ConfigurationKeys.DATABASE_TYPE)));
                    this.shutdownProxy(1);
                }
                connector = (DatabaseConnector)connectorRegistration.factory().apply("database.properties." + connectorRegistration.id() + ".");
                connector.connect();
            }
            if ((provider = registration.create(connector)) instanceof ReadWriteDatabaseProvider) {
                ReadWriteDatabaseProvider casted;
                this.databaseProvider = casted = (ReadWriteDatabaseProvider)provider;
                this.databaseConnector = connector;
            } else {
                this.logger.error("Database type %s cannot be used for writing, please use a different one".formatted(this.configuration.get(ConfigurationKeys.DATABASE_TYPE)));
                this.shutdownProxy(1);
            }
        }
        catch (Exception e) {
            cause = GeneralUtil.getFurthestCause(e);
            this.logger.error("!! THIS IS MOST LIKELY NOT AN ERROR CAUSED BY LIBRELOGIN !!");
            this.logger.error("Failed to connect to the database, this most likely is caused by wrong credentials. Cause: %s: %s".formatted(cause.getClass().getSimpleName(), ((Throwable)cause).getMessage()));
            this.shutdownProxy(1);
        }
        this.logger.info("Successfully connected to the database");
        cause = this.databaseProvider;
        if (cause instanceof AuthenticDatabaseProvider) {
            AuthenticDatabaseProvider casted = (AuthenticDatabaseProvider)cause;
            this.logger.info("Validating schema");
            try {
                casted.validateSchema();
            }
            catch (Exception e) {
                Throwable cause2 = GeneralUtil.getFurthestCause(e);
                this.logger.error("Failed to validate schema! Cause: %s: %s".formatted(cause2.getClass().getSimpleName(), cause2.getMessage()));
                this.logger.error("Please open an issue on our GitHub, or visit Discord support");
                this.shutdownProxy(1);
            }
            this.logger.info("Schema validated");
        }
    }

    private void loadConfigs() {
        this.logger.info("Loading messages...");
        this.messages = new HoconMessages(this.logger);
        try {
            this.messages.reload(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("An unknown exception occurred while attempting to load the messages, this most likely isn't your fault");
            this.shutdownProxy(1);
        }
        catch (CorruptedConfigurationException e) {
            Throwable cause = GeneralUtil.getFurthestCause(e);
            this.logger.error("!! THIS IS MOST LIKELY NOT AN ERROR CAUSED BY LIBRELOGIN !!");
            this.logger.error("!!The messages are corrupted, please look below for further clues. If you are clueless, delete the messages and a new ones will be created for you. Cause: %s: %s".formatted(cause.getClass().getSimpleName(), cause.getMessage()));
            this.shutdownProxy(1);
        }
        this.logger.info("Loading configuration...");
        ArrayList defaults = new ArrayList();
        for (DatabaseConnectorRegistration databaseConnectorRegistration : this.databaseConnectors.values()) {
            if (databaseConnectorRegistration.configClass() == null) continue;
            defaults.add(new BiHolder(databaseConnectorRegistration.configClass(), (CallSite)((Object)("database.properties." + databaseConnectorRegistration.id() + "."))));
            defaults.add(new BiHolder(databaseConnectorRegistration.configClass(), (CallSite)((Object)("migration.old-database." + databaseConnectorRegistration.id() + "."))));
        }
        this.configuration = new HoconPluginConfiguration(this.logger, defaults);
        try {
            if (this.configuration.reload(this)) {
                this.logger.warn("!! A new configuration was generated, please fill it out, if in doubt, see the wiki !!");
                this.shutdownProxy(0);
            }
            List<String> limbos = this.configuration.get(ConfigurationKeys.LIMBO);
            Multimap<String, String> multimap = this.configuration.get(ConfigurationKeys.LOBBY);
            for (String value : multimap.values()) {
                if (!limbos.contains(value)) continue;
                throw new CorruptedConfigurationException("Lobby server/world %s is also a limbo server/world, this is not allowed".formatted(value));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("An unknown exception occurred while attempting to load the configuration, this most likely isn't your fault");
            this.shutdownProxy(1);
        }
        catch (CorruptedConfigurationException e) {
            Throwable throwable = GeneralUtil.getFurthestCause(e);
            this.logger.error("!! THIS IS MOST LIKELY NOT AN ERROR CAUSED BY LIBRELOGIN !!");
            this.logger.error("!!The configuration is corrupted, please look below for further clues. If you are clueless, delete the config and a new one will be created for you. Cause: %s: %s".formatted(throwable.getClass().getSimpleName(), throwable.getMessage()));
            this.shutdownProxy(1);
        }
    }

    private void setupDB() {
        this.registerDatabaseConnector(new DatabaseConnectorRegistration(prefix -> new AuthenticMySQLDatabaseConnector(this, (String)prefix), AuthenticMySQLDatabaseConnector.Configuration.class, "mysql"), MySQLDatabaseConnector.class);
        this.registerDatabaseConnector(new DatabaseConnectorRegistration(prefix -> new AuthenticSQLiteDatabaseConnector(this, (String)prefix), AuthenticSQLiteDatabaseConnector.Configuration.class, "sqlite"), SQLiteDatabaseConnector.class);
        this.registerDatabaseConnector(new DatabaseConnectorRegistration(prefix -> new AuthenticPostgreSQLDatabaseConnector(this, (String)prefix), AuthenticPostgreSQLDatabaseConnector.Configuration.class, "postgresql"), PostgreSQLDatabaseConnector.class);
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LibreLoginMySQLDatabaseProvider((MySQLDatabaseConnector)connector, (AuthenticLibreLogin<?, ?>)this), "librelogin-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LibreLoginSQLiteDatabaseProvider((SQLiteDatabaseConnector)connector, (AuthenticLibreLogin<?, ?>)this), "librelogin-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LibreLoginPostgreSQLDatabaseProvider((PostgreSQLDatabaseConnector)connector, (AuthenticLibreLogin<?, ?>)this), "librelogin-postgresql", PostgreSQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AegisSQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_MYSQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "aegis-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AuthMeSQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_MYSQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "authme-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AuthMeSQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_POSTGRESQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "authme-postgresql", PostgreSQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AuthMeSQLMigrateReadProvider("authme", this.logger, (SQLDatabaseConnector)connector), "authme-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new DBASQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_MYSQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "dba-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new JPremiumSQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_MYSQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "jpremium-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new NLoginSQLMigrateReadProvider("nlogin", this.logger, (SQLDatabaseConnector)connector), "nlogin-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new NLoginSQLMigrateReadProvider("nlogin", this.logger, (SQLDatabaseConnector)connector), "nlogin-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new FastLoginSQLMigrateReadProvider("premium", this.logger, (SQLDatabaseConnector)connector, this.databaseConnector, this.premiumProvider), "fastlogin-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new FastLoginSQLMigrateReadProvider("premium", this.logger, (SQLDatabaseConnector)connector, this.databaseConnector, this.premiumProvider), "fastlogin-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new UniqueCodeAuthSQLMigrateReadProvider("uniquecode_proxy_users", this.logger, (SQLDatabaseConnector)connector, this), "uniquecodeauth-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LoginSecuritySQLMigrateReadProvider("ls_players", this.logger, (SQLDatabaseConnector)connector), "loginsecurity-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LoginSecuritySQLMigrateReadProvider("ls_players", this.logger, (SQLDatabaseConnector)connector), "loginsecurity-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LimboAuthSQLMigrateReadProvider("AUTH", this.logger, (SQLDatabaseConnector)connector), "limboauth-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AuthySQLMigrateReadProvider("players", this.logger, (SQLDatabaseConnector)connector), "authy-mysql", MySQLDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new AuthySQLMigrateReadProvider("players", this.logger, (SQLDatabaseConnector)connector), "authy-sqlite", SQLiteDatabaseConnector.class));
        this.registerReadProvider(new ReadDatabaseProviderRegistration(connector -> new LogItSQLMigrateReadProvider(this.configuration.get(ConfigurationKeys.MIGRATION_MYSQL_OLD_DATABASE_TABLE), this.logger, (SQLDatabaseConnector)connector), "logit-mysql", MySQLDatabaseConnector.class));
    }

    private void loadForbiddenPasswords() throws IOException {
        File file = new File(this.getDataFolder(), "forbidden-passwords.txt");
        if (!file.exists()) {
            this.logger.info("Forbidden passwords list doesn't exist, downloading...");
            try (BufferedInputStream in = new BufferedInputStream(new URL("https://raw.githubusercontent.com/kyngs/LibreLogin/dev/forbidden-passwords.txt").openStream());){
                if (!file.createNewFile()) {
                    throw new IOException("Failed to create file");
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] dataBuffer = new byte[1024];
                    while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                        fos.write(dataBuffer, 0, bytesRead);
                    }
                }
                this.logger.info("Successfully downloaded forbidden passwords list");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.warn("Failed to download forbidden passwords list, using template instead");
                Files.copy(this.getResourceAsStream("forbidden-passwords-template.txt"), file.toPath(), new CopyOption[0]);
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("# ")) continue;
                this.forbiddenPasswords.add(line.toUpperCase(Locale.ROOT));
            }
        }
    }

    private void checkForUpdates() {
        this.logger.info("Checking for updates...");
        try {
            URLConnection connection = new URL("https://api.github.com/repos/Navio1430/LibreLoginProd/releases").openConnection();
            connection.setRequestProperty("User-Agent", "LibreLogin");
            InputStream in = connection.getInputStream();
            JsonArray root = (JsonArray)GSON.fromJson((Reader)new InputStreamReader(in), JsonArray.class);
            in.close();
            ArrayList<Release> behind = new ArrayList<Release>();
            SemanticVersion latest = null;
            for (JsonElement raw : root) {
                boolean shouldBreak;
                JsonObject release = raw.getAsJsonObject();
                SemanticVersion version = SemanticVersion.parse(release.get("tag_name").getAsString());
                if (latest == null) {
                    latest = version;
                }
                if (!(shouldBreak = (switch (this.version.compare(version)) {
                    case 0, 1 -> true;
                    default -> {
                        behind.add(new Release(version, release.get("name").getAsString()));
                        yield false;
                    }
                }))) continue;
                break;
            }
            if (behind.isEmpty()) {
                this.logger.info("You are running the latest version of LibreLogin");
            } else {
                Collections.reverse(behind);
                this.logger.warn("!! YOU ARE RUNNING AN OUTDATED VERSION OF LIBRELOGIN !!");
                this.logger.info("You are running version %s, the latest version is %s. You are running %s versions behind. Newer versions:".formatted(this.getVersion(), latest, behind.size()));
                for (Release release : behind) {
                    this.logger.info("- %s".formatted(release.name()));
                }
                this.logger.warn("!! PLEASE UPDATE TO THE LATEST VERSION !!");
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to check for updates", e);
        }
    }

    public UUID generateNewUUID(String name, @Nullable UUID premiumID) {
        return switch (this.configuration.getNewUUIDCreator()) {
            default -> throw new MatchException(null, null);
            case NewUUIDCreator.RANDOM -> UUID.randomUUID();
            case NewUUIDCreator.MOJANG -> {
                if (premiumID == null) {
                    yield GeneralUtil.getCrackedUUIDFromName(name);
                }
                yield premiumID;
            }
            case NewUUIDCreator.CRACKED -> GeneralUtil.getCrackedUUIDFromName(name);
        };
    }

    protected void disable() {
        if (this.databaseConnector != null) {
            try {
                this.databaseConnector.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("Failed to disconnect from database, ignoring...");
            }
        }
        if (this.luckpermsApi != null) {
            this.luckpermsApi.disable();
        }
    }

    @Override
    public xyz.kyngs.librelogin.api.Logger getLogger() {
        return this.logger;
    }

    public HoconPluginConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public HoconMessages getMessages() {
        return this.messages;
    }

    @Override
    public void checkDataFolder() {
        File folder = this.getDataFolder();
        if (!folder.exists() && !folder.mkdir()) {
            throw new RuntimeException("Failed to create datafolder");
        }
    }

    protected abstract xyz.kyngs.librelogin.api.Logger provideLogger();

    public abstract CommandManager<?, ?, ?, ?, ?, ?> provideManager();

    public abstract P getPlayerFromIssuer(CommandIssuer var1);

    public abstract void authorize(P var1, User var2, Audience var3);

    public abstract CancellableTask delay(Runnable var1, long var2);

    public abstract CancellableTask repeat(Runnable var1, long var2, long var4);

    public abstract boolean pluginPresent(String var1);

    protected abstract AuthenticImageProjector<P, S> provideImageProjector();

    public PremiumUser getUserOrThrowICA(String username) throws InvalidCommandArgument {
        try {
            return this.getPremiumProvider().getUserForName(username);
        }
        catch (PremiumException e) {
            HoconMessages hoconMessages = this.getMessages();
            throw new InvalidCommandArgument(hoconMessages.getMessage(switch (e.getIssue()) {
                case PremiumException.Issue.THROTTLED -> "error-premium-throttled";
                default -> "error-premium-unknown";
            }, new String[0]));
        }
    }

    protected abstract void initMetrics(CustomChart ... var1);

    public AuthenticAuthorizationProvider<P, S> getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    @Override
    public CryptoProvider getCryptoProvider(String id) {
        return this.cryptoProviders.get(id);
    }

    @Override
    public void registerCryptoProvider(CryptoProvider provider) {
        this.cryptoProviders.put(provider.getIdentifier(), provider);
    }

    @Override
    public CryptoProvider getDefaultCryptoProvider() {
        return this.getCryptoProvider(this.configuration.get(ConfigurationKeys.DEFAULT_CRYPTO_PROVIDER));
    }

    @Override
    public void migrate(ReadDatabaseProvider from, WriteDatabaseProvider to) {
        this.logger.info("Reading data...");
        Collection<User> users = from.getAllUsers();
        this.logger.info("Data read, inserting into database...");
        to.insertUsers(users);
    }

    @Override
    public AuthenticEventProvider<P, S> getEventProvider() {
        return this.eventProvider;
    }

    public LoginTryListener<P, S> getLoginTryListener() {
        return this.loginTryListener;
    }

    public void onExit(P player) {
        this.cancelOnExit.removeAll(player).forEach(CancellableTask::cancel);
        if (this.configuration.get(ConfigurationKeys.REMEMBER_LAST_SERVER).booleanValue()) {
            String server = this.platformHandle.getPlayersServerName(player);
            if (server == null) {
                return;
            }
            User user = this.databaseProvider.getByUUID(this.platformHandle.getUUIDForPlayer(player));
            if (user != null && !this.getConfiguration().get(ConfigurationKeys.LIMBO).contains(server)) {
                user.setLastServer(server);
                this.databaseProvider.updateUser(user);
            }
        }
    }

    public void cancelOnExit(CancellableTask task, P player) {
        this.cancelOnExit.put(player, (Object)task);
    }

    public boolean floodgateEnabled() {
        return this.floodgateApi != null;
    }

    public boolean luckpermsEnabled() {
        return this.luckpermsApi != null;
    }

    public boolean fromFloodgate(UUID uuid) {
        return this.floodgateApi != null && uuid != null && this.floodgateApi.isFloodgateId(uuid);
    }

    protected void shutdownProxy(int code) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            System.exit(code);
        }
    }

    public abstract Audience getAudienceFromIssuer(CommandIssuer var1);

    protected boolean mainThread() {
        return false;
    }

    public void reportMainThread() {
        if (this.mainThread()) {
            this.logger.error("AN IO OPERATION IS BEING PERFORMED ON THE MAIN THREAD! THIS IS A SERIOUS BUG!, PLEASE REPORT IT TO THE DEVELOPER OF THE PLUGIN AND ATTACH THE STACKTRACE BELOW!");
            new Throwable().printStackTrace();
        }
    }

    public boolean fromFloodgate(String username) {
        return this.floodgateApi != null && this.floodgateApi.getPlayer(username) != null;
    }

    protected Logger getSimpleLogger() {
        return null;
    }
}

