/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.authorization;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.AuthenticatedEvent;
import xyz.kyngs.librelogin.api.totp.TOTPData;
import xyz.kyngs.librelogin.common.AuthenticHandler;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticAuthenticatedEvent;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;

public class AuthenticAuthorizationProvider<P, S>
extends AuthenticHandler<P, S>
implements AuthorizationProvider<P> {
    private final Map<P, Boolean> unAuthorized = new ConcurrentHashMap<P, Boolean>();
    private final Map<P, String> awaiting2FA = new ConcurrentHashMap<P, String>();
    private final Cache<UUID, EmailVerifyData> emailConfirmCache;
    private final Cache<UUID, String> passwordResetCache;

    public AuthenticAuthorizationProvider(AuthenticLibreLogin<P, S> plugin) {
        super(plugin);
        Integer millis = plugin.getConfiguration().get(ConfigurationKeys.MILLISECONDS_TO_REFRESH_NOTIFICATION);
        if (millis > 0) {
            plugin.repeat(this::notifyUnauthorized, 0L, millis.intValue());
        }
        plugin.repeat(this::broadcastActionbars, 0L, 1000L);
        this.emailConfirmCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
        this.passwordResetCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    public Cache<UUID, EmailVerifyData> getEmailConfirmCache() {
        return this.emailConfirmCache;
    }

    public Cache<UUID, String> getPasswordResetCache() {
        return this.passwordResetCache;
    }

    public void onExit(P player) {
        this.stopTracking(player);
        this.awaiting2FA.remove(player);
        this.emailConfirmCache.invalidate((Object)this.platformHandle.getUUIDForPlayer(player));
        this.passwordResetCache.invalidate((Object)this.platformHandle.getUUIDForPlayer(player));
    }

    @Override
    public boolean isAuthorized(P player) {
        return !this.unAuthorized.containsKey(player);
    }

    @Override
    public boolean isAwaiting2FA(P player) {
        return this.awaiting2FA.containsKey(player);
    }

    @Override
    public void authorize(User user, P player, AuthenticatedEvent.AuthenticationReason reason) {
        if (this.isAuthorized(player)) {
            throw new IllegalStateException("Player is already authorized");
        }
        this.stopTracking(player);
        user.setLastAuthentication(Timestamp.valueOf(LocalDateTime.now()));
        user.setIp(this.platformHandle.getIP(player));
        this.plugin.getDatabaseProvider().updateUser(user);
        Audience audience = this.platformHandle.getAudienceForPlayer(player);
        audience.clearTitle();
        audience.sendActionBar(Component.empty());
        ((AuthenticEventProvider)this.plugin.getEventProvider()).fire(this.plugin.getEventTypes().authenticated, new AuthenticAuthenticatedEvent(user, player, this.plugin, reason));
        this.plugin.authorize(player, user, audience);
    }

    @Override
    public boolean confirmTwoFactorAuth(P player, Integer code, User user) {
        String secret = this.awaiting2FA.get(player);
        if (this.plugin.getTOTPProvider().verify(code, secret)) {
            user.setSecret(secret);
            this.plugin.getDatabaseProvider().updateUser(user);
            return true;
        }
        return false;
    }

    public void startTracking(User user, P player) {
        Audience audience = this.platformHandle.getAudienceForPlayer(player);
        this.unAuthorized.put(player, user.isRegistered());
        this.plugin.cancelOnExit(this.plugin.delay(() -> {
            if (!this.unAuthorized.containsKey(player)) {
                return;
            }
            this.sendInfoMessage(user.isRegistered(), audience);
        }, 250L), player);
        Integer limit = this.plugin.getConfiguration().get(ConfigurationKeys.SECONDS_TO_AUTHORIZE);
        if (limit > 0) {
            this.plugin.cancelOnExit(this.plugin.delay(() -> {
                if (!this.unAuthorized.containsKey(player)) {
                    return;
                }
                this.platformHandle.kick(player, this.plugin.getMessages().getMessage("kick-time-limit", new String[0]));
            }, (long)limit.intValue() * 1000L), player);
        }
        this.sendInfoMessage(user.isRegistered(), audience);
    }

    private void broadcastActionbars() {
        HashSet wrong = new HashSet();
        this.unAuthorized.forEach((player, registered) -> {
            Audience audience = this.platformHandle.getAudienceForPlayer(player);
            if (audience == null) {
                wrong.add(player);
                return;
            }
            this.sendActionBar((boolean)registered, audience);
        });
        wrong.forEach(this.unAuthorized::remove);
    }

    private void sendActionBar(boolean registered, Audience audience) {
        if (this.plugin.getConfiguration().get(ConfigurationKeys.USE_ACTION_BAR).booleanValue()) {
            audience.sendActionBar(this.plugin.getMessages().getMessage(registered ? "action-bar-login" : "action-bar-register", new String[0]));
        }
    }

    private void sendInfoMessage(boolean registered, Audience audience) {
        audience.sendMessage(this.plugin.getMessages().getMessage(registered ? "prompt-login" : "prompt-register", new String[0]));
        if (!this.plugin.getConfiguration().get(ConfigurationKeys.USE_TITLES).booleanValue()) {
            return;
        }
        Integer toRefresh = this.plugin.getConfiguration().get(ConfigurationKeys.MILLISECONDS_TO_REFRESH_NOTIFICATION);
        audience.showTitle(Title.title(this.plugin.getMessages().getMessage(registered ? "title-login" : "title-register", new String[0]), this.plugin.getMessages().getMessage(registered ? "sub-title-login" : "sub-title-register", new String[0]), Title.Times.of(Duration.ofMillis(0L), Duration.ofMillis(toRefresh > 0 ? (long)((double)toRefresh.intValue() * 1.1) : 10000L), Duration.ofMillis(0L))));
    }

    public void stopTracking(P player) {
        this.unAuthorized.remove(player);
    }

    public void notifyUnauthorized() {
        HashSet wrong = new HashSet();
        this.unAuthorized.forEach((player, registered) -> {
            Audience audience = this.platformHandle.getAudienceForPlayer(player);
            if (audience == null) {
                wrong.add(player);
                return;
            }
            this.sendInfoMessage((boolean)registered, audience);
        });
        wrong.forEach(this.unAuthorized::remove);
    }

    public void beginTwoFactorAuth(User user, P player, TOTPData data) {
        this.awaiting2FA.put(player, data.secret());
        Object limbo = this.plugin.getServerHandler().chooseLimboServer(user, player);
        if (limbo == null) {
            this.platformHandle.kick(player, this.plugin.getMessages().getMessage("kick-no-limbo", new String[0]));
            return;
        }
        this.platformHandle.movePlayer(player, limbo).whenComplete((t, e) -> {
            if (t != null || e != null) {
                this.awaiting2FA.remove(player);
            }
        });
    }

    public record EmailVerifyData(String email, String token, UUID uuid) {
    }
}

