/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command;

import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandManager;
import co.aikar.commands.Locales;
import co.aikar.commands.MessageKeys;
import co.aikar.locales.MessageKeyProvider;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticHandler;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.ChangePasswordCommand;
import xyz.kyngs.librelogin.common.command.commands.authorization.LoginCommand;
import xyz.kyngs.librelogin.common.command.commands.authorization.RegisterCommand;
import xyz.kyngs.librelogin.common.command.commands.mail.ConfirmPasswordReset;
import xyz.kyngs.librelogin.common.command.commands.mail.ResetPasswordViaEMailCommand;
import xyz.kyngs.librelogin.common.command.commands.mail.SetEMailCommand;
import xyz.kyngs.librelogin.common.command.commands.mail.VerifyEMailCommand;
import xyz.kyngs.librelogin.common.command.commands.premium.PremiumConfirmCommand;
import xyz.kyngs.librelogin.common.command.commands.premium.PremiumDisableCommand;
import xyz.kyngs.librelogin.common.command.commands.premium.PremiumEnableCommand;
import xyz.kyngs.librelogin.common.command.commands.staff.LibreLoginCommand;
import xyz.kyngs.librelogin.common.command.commands.tfa.TwoFactorAuthCommand;
import xyz.kyngs.librelogin.common.command.commands.tfa.TwoFactorConfirmCommand;
import xyz.kyngs.librelogin.common.util.RateLimiter;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;

public class CommandProvider<P, S>
extends AuthenticHandler<P, S> {
    public static final LegacyComponentSerializer ACF_SERIALIZER = LegacyComponentSerializer.legacySection();
    private final CommandManager<?, ?, ?, ?, ?, ?> manager;
    private final RateLimiter<UUID> limiter = new RateLimiter(1L, TimeUnit.SECONDS);
    private final Cache<UUID, Object> confirmCache;

    public CommandProvider(AuthenticLibreLogin<P, S> plugin) {
        super(plugin);
        this.manager = plugin.provideManager();
        this.injectMessages();
        CommandContexts contexts = this.manager.getCommandContexts();
        contexts.registerIssuerAwareContext(Audience.class, context -> {
            if (this.limiter.tryAndLimit(context.getIssuer().getUniqueId())) {
                throw new InvalidCommandArgument(plugin.getMessages().getMessage("error-throttle", new String[0]));
            }
            return plugin.getAudienceFromIssuer(context.getIssuer());
        });
        contexts.registerIssuerAwareContext(Object.class, context -> {
            Object player = plugin.getPlayerFromIssuer(context.getIssuer());
            if (player == null) {
                throw new co.aikar.commands.InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return player;
        });
        contexts.registerIssuerAwareContext(UUID.class, context -> {
            Object player = plugin.getPlayerFromIssuer(context.getIssuer());
            if (player == null) {
                throw new co.aikar.commands.InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return plugin.getPlatformHandle().getUUIDForPlayer(player);
        });
        this.manager.setDefaultExceptionHandler((command, registeredCommand, sender, args, t) -> {
            if (!(t instanceof InvalidCommandArgument)) {
                Logger logger = plugin.getLogger();
                logger.error("An unexpected exception occurred while performing command, please attach the stacktrace below and report this issue.");
                t.printStackTrace();
                return false;
            }
            InvalidCommandArgument ourEx = (InvalidCommandArgument)t;
            plugin.getAudienceFromIssuer(sender).sendMessage(ourEx.getUserFuckUp());
            return true;
        }, false);
        this.confirmCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.manager.registerCommand(new LoginCommand<P>(plugin));
        this.manager.registerCommand(new RegisterCommand<P>(plugin));
        this.manager.registerCommand(new PremiumEnableCommand<P>(plugin));
        this.manager.registerCommand(new PremiumConfirmCommand<P>(plugin));
        this.manager.registerCommand(new PremiumDisableCommand<P>(plugin));
        this.manager.registerCommand(new ChangePasswordCommand<P>(plugin));
        this.manager.registerCommand(new LibreLoginCommand<P>(plugin));
        if (plugin.getTOTPProvider() != null) {
            this.manager.registerCommand(new TwoFactorAuthCommand<P>(plugin));
            this.manager.registerCommand(new TwoFactorConfirmCommand<P>(plugin));
        }
        if (plugin.getEmailHandler() != null) {
            this.manager.registerCommand(new SetEMailCommand<P>(plugin));
            this.manager.registerCommand(new VerifyEMailCommand<P>(plugin));
            this.manager.registerCommand(new ResetPasswordViaEMailCommand<P>(plugin));
            this.manager.registerCommand(new ConfirmPasswordReset<P>(plugin));
        }
    }

    public void registerConfirm(UUID uuid) {
        this.confirmCache.put((Object)uuid, new Object());
    }

    public void onConfirm(P player, Audience audience, User user) {
        if (this.confirmCache.asMap().remove(user.getUuid()) == null) {
            throw new InvalidCommandArgument(this.plugin.getMessages().getMessage("error-no-confirm", new String[0]));
        }
        audience.sendMessage(this.plugin.getMessages().getMessage("info-enabling", new String[0]));
        LibreLoginCommand.enablePremium(player, user, this.plugin, true);
        this.plugin.getDatabaseProvider().updateUser(user);
        this.platformHandle.kick(player, this.plugin.getMessages().getMessage("kick-premium-info-enabled", new String[0]));
    }

    public TextComponent getMessage(String key) {
        return this.plugin.getMessages().getMessage(key, new String[0]);
    }

    private String getMessageAsString(String key) {
        return ACF_SERIALIZER.serialize((Component)this.getMessage(key));
    }

    public RateLimiter<UUID> getLimiter() {
        return this.limiter;
    }

    public void injectMessages() {
        Locales locales = this.manager.getLocales();
        HashMap<String, String> localeMap = new HashMap<String, String>();
        localeMap.put("acf-core.permission_denied", this.getMessageAsString("error-no-permission"));
        localeMap.put("acf-core.permission_denied_parameter", this.getMessageAsString("error-no-permission"));
        localeMap.put("acf-core.invalid_syntax", this.getMessageAsString("error-invalid-syntax"));
        localeMap.put("acf-core.unknown_command", this.getMessageAsString("error-unknown-command"));
        this.plugin.getMessages().getMessages().forEach((key, value) -> {
            if (key.startsWith("syntax")) {
                localeMap.put((String)key, ACF_SERIALIZER.serialize((Component)value));
            } else if (key.startsWith("autocomplete")) {
                String serialized = ACF_SERIALIZER.serialize((Component)value);
                this.manager.getCommandReplacements().addReplacement(key, (String)(serialized.isBlank() ? serialized : serialized + " @nothing"));
            }
        });
        locales.addMessageStrings(locales.getDefaultLocale(), localeMap);
    }
}

