/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.authorization;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Syntax;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.AuthenticatedEvent;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.authorization.AuthorizationCommand;

@CommandAlias(value="register|reg")
public class RegisterCommand<P>
extends AuthorizationCommand<P> {
    public RegisterCommand(AuthenticLibreLogin<P, ?> premium) {
        super(premium);
    }

    @Default
    @Syntax(value="{@@syntax.register}")
    @CommandCompletion(value="%autocomplete.register")
    public CompletionStage<Void> onRegister(Audience sender, P player, @Single String password, String passwordRepeat) {
        return this.runAsync(() -> {
            this.checkUnauthorized(player);
            User user = this.getUser(player);
            if (user.isRegistered()) {
                throw new InvalidCommandArgument(this.getMessage("error-already-registered", new String[0]));
            }
            if (!password.contentEquals(passwordRepeat)) {
                throw new InvalidCommandArgument(this.getMessage("error-password-not-match", new String[0]));
            }
            this.setPassword(sender, user, password, "info-registering");
            sender.sendMessage(this.getMessage("info-registered", new String[0]));
            this.getAuthorizationProvider().authorize(user, player, AuthenticatedEvent.AuthenticationReason.REGISTER);
        });
    }
}

