/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.mail;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Syntax;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.mail.EMailCommand;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.common.util.RateLimiter;

@CommandAlias(value="resetpassword")
public class ResetPasswordViaEMailCommand<P>
extends EMailCommand<P> {
    private final RateLimiter<UUID> limiter = new RateLimiter(1L, TimeUnit.MINUTES);

    public ResetPasswordViaEMailCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.reset-password}")
    @CommandCompletion(value="%autocomplete.reset-password")
    public CompletionStage<Void> onResetPassword(Audience audience, P player, UUID uuid) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            if (user.getEmail() == null) {
                throw new InvalidCommandArgument(this.getMessage("error-no-email", new String[0]));
            }
            if (this.limiter.tryAndLimit(uuid)) {
                throw new InvalidCommandArgument(this.getMessage("error-mail-throttle", new String[0]));
            }
            String token = GeneralUtil.generateAlphanumericText(16);
            audience.sendMessage(this.getMessage("info-mail-sending", new String[0]));
            try {
                this.mailHandler.sendPasswordResetMail(user.getEmail(), token, user.getLastNickname(), this.plugin.getPlatformHandle().getIP(player));
                this.getAuthorizationProvider().getPasswordResetCache().put((Object)uuid, (Object)token);
            }
            catch (Exception e) {
                if (this.plugin.getConfiguration().get(ConfigurationKeys.DEBUG).booleanValue()) {
                    this.getLogger().debug("Cannot send verification mail to " + user.getEmail() + " for " + String.valueOf(player));
                    e.printStackTrace();
                }
                throw new InvalidCommandArgument(this.getMessage("error-mail-not-sent", new String[0]));
            }
            audience.sendMessage(this.getMessage("info-reset-password-mail-sent", new String[0]));
        });
    }
}

