/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.mail;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Syntax;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.WrongPasswordEvent;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.mail.EMailCommand;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticWrongPasswordEvent;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.common.util.RateLimiter;

@CommandAlias(value="setemail")
public class SetEMailCommand<P>
extends EMailCommand<P> {
    private final RateLimiter<UUID> limiter = new RateLimiter(1L, TimeUnit.MINUTES);

    public SetEMailCommand(AuthenticLibreLogin<P, ?> premium) {
        super(premium);
    }

    @Default
    @Syntax(value="{@@syntax.set-email}")
    @CommandCompletion(value="%autocomplete.set-email")
    public CompletionStage<Void> onSetMail(Audience sender, P player, UUID uuid, String mail, @Single String password) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            HashedPassword hashed = user.getHashedPassword();
            CryptoProvider crypto = this.getCrypto(hashed);
            if (!crypto.matches(password, hashed)) {
                ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().wrongPassword, new AuthenticWrongPasswordEvent(user, player, this.plugin, WrongPasswordEvent.AuthenticationSource.SET_EMAIL));
                throw new InvalidCommandArgument(this.getMessage("error-password-wrong", new String[0]));
            }
            if (this.limiter.tryAndLimit(uuid)) {
                throw new InvalidCommandArgument(this.getMessage("error-mail-throttle", new String[0]));
            }
            String token = GeneralUtil.generateAlphanumericText(16);
            sender.sendMessage(this.getMessage("info-mail-sending", new String[0]));
            try {
                this.mailHandler.sendVerificationMail(mail, token, user.getLastNickname());
                this.getAuthorizationProvider().getEmailConfirmCache().put((Object)uuid, (Object)new AuthenticAuthorizationProvider.EmailVerifyData(mail, token, uuid));
            }
            catch (Exception e) {
                if (this.plugin.getConfiguration().get(ConfigurationKeys.DEBUG).booleanValue()) {
                    this.getLogger().debug("Cannot send verification mail to " + mail + " for " + String.valueOf(player));
                    e.printStackTrace();
                }
                throw new InvalidCommandArgument(this.getMessage("error-mail-not-sent", new String[0]));
            }
            sender.sendMessage(this.getMessage("info-verification-mail-sent", new String[0]));
        });
    }
}

