/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.staff;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.annotation.Syntax;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.AuthenticatedEvent;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.staff.StaffCommand;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticPasswordChangeEvent;
import xyz.kyngs.librelogin.common.event.events.AuthenticPremiumLoginSwitchEvent;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

@CommandAlias(value="librelogin")
public class LibreLoginCommand<P>
extends StaffCommand<P> {
    public LibreLoginCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Subcommand(value="about")
    @Default
    public CompletionStage<Void> onAbout(Audience audience) {
        return this.runAsync(() -> audience.sendMessage(this.getMessage("info-about", "%version%", this.plugin.getVersion())));
    }

    @Subcommand(value="email test")
    @CommandPermission(value="librelogin.email.test")
    @Syntax(value="{@@syntax.email-test}")
    @CommandCompletion(value="%autocomplete.email-test")
    public CompletionStage<Void> onEmailTest(Audience audience, String email) {
        return this.runAsync(() -> {
            if (this.plugin.getEmailHandler() == null) {
                throw new InvalidCommandArgument(this.getMessage("error-password-resetting-disabled", new String[0]));
            }
            audience.sendMessage(this.getMessage("info-sending-email", new String[0]));
            this.plugin.getEmailHandler().sendTestMail(email);
            audience.sendMessage(this.getMessage("info-sent-email", new String[0]));
        });
    }

    @Subcommand(value="dump")
    @CommandPermission(value="librelogin.dump")
    public CompletionStage<Void> onDump(Audience audience) {
        return this.runAsync(() -> {
            File dumpFile;
            audience.sendMessage(this.getMessage("info-dumping", new String[0]));
            File dumpFolder = new File(this.plugin.getDataFolder(), "dumps");
            if (!dumpFolder.exists()) {
                dumpFolder.mkdirs();
            }
            if ((dumpFile = new File(dumpFolder, "dump-%date%.json".replace("%date%", DateTimeFormatter.ofPattern("dd-MM-yyyy_HH-mm-ss").format(LocalDateTime.now())))).exists()) {
                dumpFile.delete();
            }
            try {
                dumpFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidCommandArgument(this.getMessage("error-unknown", new String[0]));
            }
            JsonObject dump = new JsonObject();
            dump.addProperty("version", this.plugin.getVersion());
            dump.addProperty("date", AuthenticLibreLogin.DATE_TIME_FORMATTER.format(LocalDateTime.now()));
            JsonObject server = new JsonObject();
            PlatformHandle.ProxyData proxyData = this.plugin.getPlatformHandle().getProxyData();
            server.addProperty("name", proxyData.name());
            server.add("plugins", AuthenticLibreLogin.GSON.toJsonTree(proxyData.plugins()));
            server.add("servers", AuthenticLibreLogin.GSON.toJsonTree(proxyData.servers()));
            server.add("limbos", AuthenticLibreLogin.GSON.toJsonTree(proxyData.limbos()));
            server.add("lobbies", AuthenticLibreLogin.GSON.toJsonTree(proxyData.lobbies()));
            JsonObject threads = new JsonObject();
            ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
            for (ThreadInfo info : mxBean.dumpAllThreads(true, true)) {
                JsonObject thread = new JsonObject();
                thread.addProperty("id", (Number)info.getThreadId());
                thread.addProperty("name", info.getThreadName());
                thread.addProperty("state", info.getThreadState().name());
                thread.addProperty("priority", (Number)info.getPriority());
                thread.addProperty("isDaemon", Boolean.valueOf(info.isDaemon()));
                thread.addProperty("isInNative", Boolean.valueOf(info.isInNative()));
                thread.addProperty("isSuspended", Boolean.valueOf(info.isSuspended()));
                JsonObject lock = new JsonObject();
                if (info.getLockName() != null) {
                    lock.addProperty("name", info.getLockName());
                    lock.addProperty("ownerId", (Number)info.getLockOwnerId());
                    lock.addProperty("ownerName", info.getLockOwnerName());
                }
                thread.add("lock", (JsonElement)lock);
                JsonArray stackTrace = new JsonArray();
                for (StackTraceElement element : info.getStackTrace()) {
                    stackTrace.add(element.getClassName() + "#" + element.getMethodName() + "#" + element.getLineNumber());
                }
                thread.add("stackTrace", (JsonElement)stackTrace);
                threads.add(info.getThreadName(), (JsonElement)thread);
            }
            server.add("threads", (JsonElement)threads);
            dump.add("server", (JsonElement)server);
            try (FileWriter writer = new FileWriter(dumpFile);){
                writer.write(AuthenticLibreLogin.GSON.toJson((JsonElement)dump));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidCommandArgument(this.getMessage("error-unknown", new String[0]));
            }
            audience.sendMessage(this.getMessage("info-dumped", "%file%", dumpFile.getPath()));
        });
    }

    @Subcommand(value="reload configuration")
    @CommandPermission(value="librepremium.reload.configuration")
    public CompletionStage<Void> onReloadConfiguration(Audience audience) {
        return this.runAsync(() -> {
            audience.sendMessage(this.getMessage("info-reloading", new String[0]));
            try {
                this.plugin.getConfiguration().reload(this.plugin);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidCommandArgument(this.getMessage("error-unknown", new String[0]));
            }
            catch (CorruptedConfigurationException e) {
                Throwable cause = GeneralUtil.getFurthestCause(e);
                throw new InvalidCommandArgument(this.getMessage("error-corrupted-configuration", "%cause%", "%s: %s".formatted(cause.getClass().getSimpleName(), cause.getMessage())));
            }
            audience.sendMessage(this.getMessage("info-reloaded", new String[0]));
        });
    }

    @Subcommand(value="reload messages")
    @CommandPermission(value="librepremium.reload.messages")
    public CompletionStage<Void> onReloadMessages(Audience audience) {
        return this.runAsync(() -> {
            audience.sendMessage(this.getMessage("info-reloading", new String[0]));
            try {
                this.plugin.getMessages().reload(this.plugin);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidCommandArgument(this.getMessage("error-unknown", new String[0]));
            }
            catch (CorruptedConfigurationException e) {
                Throwable cause = GeneralUtil.getFurthestCause(e);
                throw new InvalidCommandArgument(this.getMessage("error-corrupted-messages", "%cause%", "%s: %s".formatted(cause.getClass().getSimpleName(), cause.getMessage())));
            }
            this.plugin.getCommandProvider().injectMessages();
            audience.sendMessage(this.getMessage("info-reloaded", new String[0]));
        });
    }

    @Subcommand(value="user info")
    @CommandPermission(value="librepremium.user.info")
    @Syntax(value="{@@syntax.user-info}")
    @CommandCompletion(value="%autocomplete.user-info")
    public CompletionStage<Void> onUserInfo(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            audience.sendMessage(this.getMessage("info-user", "%uuid%", user.getUuid().toString(), "%premium_uuid%", user.getPremiumUUID() == null ? "N/A" : user.getPremiumUUID().toString(), "%last_seen%", AuthenticLibreLogin.DATE_TIME_FORMATTER.format(user.getLastSeen().toLocalDateTime()), "%joined%", AuthenticLibreLogin.DATE_TIME_FORMATTER.format(user.getJoinDate().toLocalDateTime()), "%2fa%", user.getSecret() != null ? "Enabled" : "Disabled", "%email%", user.getEmail() == null ? "N/A" : user.getEmail(), "%ip%", user.getIp() == null ? "N/A" : user.getIp(), "%last_authenticated%", user.getLastAuthentication() == null ? "N/A" : AuthenticLibreLogin.DATE_TIME_FORMATTER.format(user.getLastAuthentication().toLocalDateTime())));
        });
    }

    public static <P> void enablePremium(P player, User user, AuthenticLibreLogin<P, ?> plugin, boolean onlyValid) {
        PremiumUser id = plugin.getUserOrThrowICA(user.getLastNickname());
        if (onlyValid && id != null && !id.reliable()) {
            plugin.getLogger().warn("Data retrieved from premium provider is not reliable for user %s, can not safely enable premium login. \nPlease verify the correct capitalization using site such as NameMC and then enable it manually using the /librelogin user premium command.".formatted(user.getLastNickname()));
            throw new InvalidCommandArgument(plugin.getMessages().getMessage("error-not-paid", new String[0]));
        }
        if (id == null || !id.name().equals(user.getLastNickname())) {
            throw new InvalidCommandArgument(plugin.getMessages().getMessage("error-not-paid", new String[0]));
        }
        user.setPremiumUUID(id.uuid());
        ((AuthenticEventProvider)plugin.getEventProvider()).unsafeFire(plugin.getEventTypes().premiumLoginSwitch, new AuthenticPremiumLoginSwitchEvent(user, player, plugin));
    }

    @Subcommand(value="user migrate")
    @CommandPermission(value="librepremium.user.migrate")
    @Syntax(value="{@@syntax.user-migrate}")
    @CommandCompletion(value="%autocomplete.user-migrate")
    public CompletionStage<Void> onUserMigrate(Audience audience, String name, String newName) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            User colliding = this.getDatabaseProvider().getByName(newName);
            if (colliding != null && !colliding.getUuid().equals(user.getUuid())) {
                throw new InvalidCommandArgument(this.getMessage("error-occupied-user", "%name%", newName));
            }
            this.requireOffline(user);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setLastNickname(newName);
            if (user.getPremiumUUID() != null) {
                user.setPremiumUUID(null);
                ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().premiumLoginSwitch, new AuthenticPremiumLoginSwitchEvent(user, null, this.plugin));
            }
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
        });
    }

    @Subcommand(value="user unregister")
    @CommandPermission(value="librepremium.user.unregister")
    @Syntax(value="{@@syntax.user-unregister}")
    @CommandCompletion(value="%autocomplete.user-unregister")
    public CompletionStage<Void> onUserUnregister(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            this.requireOffline(user);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setHashedPassword(null);
            user.setSecret(null);
            user.setIp(null);
            user.setLastAuthentication(null);
            user.setPremiumUUID(null);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
        });
    }

    @Subcommand(value="user delete")
    @CommandPermission(value="librepremium.user.delete")
    @Syntax(value="{@@syntax.user-delete}")
    @CommandCompletion(value="%autocomplete.user-delete")
    public CompletionStage<Void> onUserDelete(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            this.requireOffline(user);
            audience.sendMessage(this.getMessage("info-deleting", new String[0]));
            this.getDatabaseProvider().deleteUser(user);
            audience.sendMessage(this.getMessage("info-deleted", new String[0]));
        });
    }

    @Subcommand(value="user premium")
    @CommandPermission(value="librepremium.user.premium")
    @Syntax(value="{@@syntax.user-premium}")
    @CommandCompletion(value="%autocomplete.user-premium")
    public CompletionStage<Void> onUserPremium(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            Object player = this.getPossiblyOnlinePlayerOnThisProxy(user);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            LibreLoginCommand.enablePremium(null, user, this.plugin, false);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
            if (player != null) {
                this.plugin.getPlatformHandle().kick(player, this.getMessage("kick-premium-info-enabled", new String[0]));
            }
        });
    }

    @Subcommand(value="user cracked")
    @CommandPermission(value="librepremium.user.cracked")
    @Syntax(value="{@@syntax.user-cracked}")
    @CommandCompletion(value="%autocomplete.user-cracked")
    public CompletionStage<Void> onUserCracked(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            Object player = this.getPossiblyOnlinePlayerOnThisProxy(user);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setPremiumUUID(null);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
            if (player != null) {
                this.plugin.getPlatformHandle().kick(player, this.getMessage("kick-premium-info-disabled", new String[0]));
            }
        });
    }

    @Subcommand(value="user register")
    @CommandPermission(value="librepremium.user.register")
    @Syntax(value="{@@syntax.user-register}")
    @CommandCompletion(value="%autocomplete.user-register")
    public CompletionStage<Void> onUserRegister(Audience audience, String name, String password) {
        return this.runAsync(() -> {
            audience.sendMessage(this.getMessage("info-registering", new String[0]));
            User user = this.getDatabaseProvider().getByName(name);
            if (user != null) {
                throw new InvalidCommandArgument(this.getMessage("error-occupied-user", new String[0]));
            }
            HashedPassword hashedPassword = this.plugin.getDefaultCryptoProvider().createHash(password);
            if (hashedPassword == null) {
                throw new InvalidCommandArgument(this.getMessage("error-password-too-long", new String[0]));
            }
            PremiumUser premiumUser = this.plugin.getUserOrThrowICA(name);
            user = new AuthenticUser(this.plugin.generateNewUUID(name, premiumUser == null ? null : premiumUser.uuid()), null, hashedPassword, name, Timestamp.valueOf(LocalDateTime.now()), Timestamp.valueOf(LocalDateTime.now()), null, null, Timestamp.valueOf(LocalDateTime.now()), null, null);
            this.getDatabaseProvider().insertUser(user);
            audience.sendMessage(this.getMessage("info-registered", new String[0]));
        });
    }

    @Subcommand(value="user login")
    @CommandPermission(value="librepremium.user.login")
    @Syntax(value="{@@syntax.user-login}")
    @CommandCompletion(value="%autocomplete.user-login")
    public CompletionStage<Void> onUserLogin(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            Object target = this.requireOnline(user);
            this.requireUnAuthorized(target);
            this.requireRegistered(user);
            audience.sendMessage(this.getMessage("info-logging-in", new String[0]));
            ((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).authorize(user, target, AuthenticatedEvent.AuthenticationReason.LOGIN);
            audience.sendMessage(this.getMessage("info-logged-in", new String[0]));
        });
    }

    @Subcommand(value="user 2faoff")
    @CommandPermission(value="librepremium.user.2faoff")
    @Syntax(value="{@@syntax.user-2fa-off}")
    @CommandCompletion(value="%autocomplete.user-2fa-off")
    public CompletionStage<Void> onUser2FAOff(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setSecret(null);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
        });
    }

    @Subcommand(value="user emailoff")
    @CommandPermission(value="librepremium.user.emailoff")
    @Syntax(value="{@@syntax.user-email-off}")
    @CommandCompletion(value="%autocomplete.user-email-off")
    public CompletionStage<Void> onUserEMailOff(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setEmail(null);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
        });
    }

    @Subcommand(value="user setemail")
    @CommandPermission(value="librepremium.user.setemail")
    @Syntax(value="{@@syntax.user-set-email}")
    @CommandCompletion(value="%autocomplete.user-set-email")
    public CompletionStage<Void> onUserSetEMail(Audience audience, String name, String email) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            audience.sendMessage(this.getMessage("info-editing", new String[0]));
            user.setEmail(email);
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
        });
    }

    @Subcommand(value="user pass-change")
    @CommandPermission(value="librepremium.user.pass-change")
    @Syntax(value="{@@syntax.user-pass-change}")
    @CommandCompletion(value="%autocomplete.user-pass-change")
    public CompletionStage<Void> onUserPasswordChange(Audience audience, String name, String password) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            HashedPassword old = user.getHashedPassword();
            this.setPassword(audience, user, password, "info-editing");
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage(this.getMessage("info-edited", new String[0]));
            ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().passwordChange, new AuthenticPasswordChangeEvent(user, null, this.plugin, old));
        });
    }

    @Subcommand(value="user alts")
    @CommandPermission(value="librelogin.user.alts")
    @Syntax(value="{@@syntax.user-alts}")
    @CommandCompletion(value="%autocomplete.user-alts")
    public CompletionStage<Void> onUserAlts(Audience audience, String name) {
        return this.runAsync(() -> {
            User user = this.getUserOtherWiseInform(name);
            Collection<User> alts = this.getDatabaseProvider().getByIP(user.getIp());
            if (alts.isEmpty()) {
                audience.sendMessage(this.getMessage("info-no-alts", new String[0]));
                return;
            }
            audience.sendMessage(this.getMessage("info-alts", "%count%", String.valueOf(alts.size())));
            for (User alt : alts) {
                audience.sendMessage(this.getMessage("info-alts-entry", "%name%", alt.getLastNickname(), "%last_seen%", AuthenticLibreLogin.DATE_TIME_FORMATTER.format(user.getLastSeen().toLocalDateTime())));
            }
        });
    }
}

