/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.tfa;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.Default;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.totp.TOTPData;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.Command;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;

@CommandAlias(value="2fa|2fauth|2fauthcode")
public class TwoFactorAuthCommand<P>
extends Command<P> {
    public TwoFactorAuthCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    public CompletionStage<Void> onTwoFactorAuth(Audience sender, P player) {
        return this.runAsync(() -> {
            this.checkAuthorized(player);
            User user = this.getUser(player);
            AuthorizationProvider auth = this.plugin.getAuthorizationProvider();
            if (((AuthenticAuthorizationProvider)auth).isAwaiting2FA(player)) {
                throw new InvalidCommandArgument(this.getMessage("totp-show-info", new String[0]));
            }
            if (!this.plugin.getImageProjector().canProject(player)) {
                throw new InvalidCommandArgument(this.getMessage("totp-wrong-version", "%low%", "1.13", "%high%", "1.21.1"));
            }
            sender.sendMessage(this.getMessage("totp-generating", new String[0]));
            TOTPData data = this.plugin.getTOTPProvider().generate(user);
            ((AuthenticAuthorizationProvider)auth).beginTwoFactorAuth(user, player, data);
            this.plugin.cancelOnExit(this.plugin.delay(() -> {
                this.plugin.getImageProjector().project(data.qr(), player);
                sender.sendMessage(this.getMessage("totp-show-info", new String[0]));
            }, this.plugin.getConfiguration().get(ConfigurationKeys.TOTP_DELAY).intValue()), player);
        });
    }
}

