/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.tfa;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Syntax;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.Command;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;

@CommandAlias(value="2faconfirm")
public class TwoFactorConfirmCommand<P>
extends Command<P> {
    public TwoFactorConfirmCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.2fa-confirm}")
    @CommandCompletion(value="%autocomplete.2fa-confirm")
    public CompletionStage<Void> onTwoFactorConfirm(Audience sender, P player, String code) {
        return this.runAsync(() -> {
            int parsedCode;
            this.checkAuthorized(player);
            User user = this.getUser(player);
            AuthorizationProvider auth = this.plugin.getAuthorizationProvider();
            if (!((AuthenticAuthorizationProvider)auth).isAwaiting2FA(player)) {
                throw new InvalidCommandArgument(this.getMessage("totp-not-awaiting", new String[0]));
            }
            try {
                parsedCode = Integer.parseInt(code.trim().replace(" ", ""));
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument(this.getMessage("totp-wrong", new String[0]));
            }
            if (!((AuthenticAuthorizationProvider)auth).confirmTwoFactorAuth(player, parsedCode, user)) {
                throw new InvalidCommandArgument(this.getMessage("totp-wrong", new String[0]));
            }
            this.plugin.getPlatformHandle().kick(player, this.getMessage("kick-2fa-enabled", new String[0]));
        });
    }
}

