/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;
import xyz.kyngs.librelogin.common.config.migrate.ConfigurationMigrator;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.lib.configurate.CommentedConfigurationNode;
import xyz.kyngs.librelogin.lib.configurate.ConfigurateException;
import xyz.kyngs.librelogin.lib.configurate.ConfigurationNode;
import xyz.kyngs.librelogin.lib.configurate.ConfigurationOptions;
import xyz.kyngs.librelogin.lib.configurate.hocon.HoconConfigurationLoader;

public class ConfigurateConfiguration {
    private final ConfigurateHelper helper;
    private final boolean newlyCreated;
    private final HoconConfigurationLoader loader;

    public ConfigurateConfiguration(File dataFolder, String name, Collection<BiHolder<Class<?>, String>> defaultKeys, String comment, Logger logger, ConfigurationMigrator ... migrators) throws IOException, CorruptedConfigurationException {
        int revision = migrators.length;
        File file = new File(dataFolder, name);
        if (!file.exists()) {
            this.newlyCreated = true;
            if (!file.createNewFile()) {
                throw new IOException("Could not create configuration file!");
            }
        } else {
            this.newlyCreated = false;
        }
        ConfigurateHelper refHelper = new ConfigurateHelper((CommentedConfigurationNode)CommentedConfigurationNode.root().comment(comment));
        List<BiHolder> extractedKeys = defaultKeys.stream().map(data -> new BiHolder(GeneralUtil.extractKeys((Class)data.key()), (String)data.value())).toList();
        for (BiHolder key : extractedKeys) {
            for (ConfigurationKey configurationKey : (List)key.key()) {
                refHelper.setDefault(configurationKey, (String)key.value());
            }
        }
        CommentedConfigurationNode ref = refHelper.configuration();
        HoconConfigurationLoader.Builder builder = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(ConfigurationOptions.defaults().header(ref.comment()))).file(file)).emitComments(true).prettyPrinting(true);
        this.loader = builder.build();
        try {
            this.helper = new ConfigurateHelper((CommentedConfigurationNode)((CommentedConfigurationNode)this.loader.load()).mergeFrom((ConfigurationNode)ref));
        }
        catch (ConfigurateException e) {
            throw new CorruptedConfigurationException(e);
        }
        Integer presentRevision = this.helper.getInt("revision");
        if (presentRevision == null) {
            presentRevision = this.newlyCreated ? revision : 0;
        }
        if (presentRevision < revision) {
            for (int i = presentRevision.intValue(); i < revision; ++i) {
                migrators[i].migrate(this.helper, logger);
            }
        }
        this.helper.configuration().mergeFrom((ConfigurationNode)ref);
        ((CommentedConfigurationNode)((CommentedConfigurationNode)this.helper.configuration().node(new Object[]{"revision"})).set((Object)revision)).comment("The config revision number. !!DO NOT TOUCH THIS!!");
        for (BiHolder key : extractedKeys) {
            for (ConfigurationKey configurationKey : (List)key.key()) {
                this.helper.setComment(configurationKey, (String)key.value());
            }
        }
        this.save();
    }

    public ConfigurateHelper getHelper() {
        return this.helper;
    }

    public boolean isNewlyCreated() {
        return this.newlyCreated;
    }

    public void save() throws IOException {
        this.loader.save((ConfigurationNode)this.helper.configuration());
    }
}

