/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.api.configuration.Messages;
import xyz.kyngs.librelogin.common.config.ConfigurateConfiguration;
import xyz.kyngs.librelogin.common.config.MessageKeys;
import xyz.kyngs.librelogin.common.config.migrate.messages.FirstMessagesMigrator;
import xyz.kyngs.librelogin.common.config.migrate.messages.SecondMessagesMigrator;
import xyz.kyngs.librelogin.common.config.migrate.messages.ThirdMessagesMigrator;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.lib.configurate.CommentedConfigurationNode;
import xyz.kyngs.utils.legacymessage.LegacyMessage;

public class HoconMessages
implements Messages {
    private static final MiniMessage SERIALIZER = MiniMessage.builder().build();
    private final Map<String, TextComponent> messages;
    private final Logger logger;
    private ConfigurateConfiguration rawMessages;

    public HoconMessages(Logger logger) {
        this.logger = logger;
        this.messages = new HashMap<String, TextComponent>();
    }

    public Map<String, TextComponent> getMessages() {
        return this.messages;
    }

    @Override
    public TextComponent getMessage(String key, String ... replacements) {
        TextComponent message = this.messages.get(key);
        if (replacements.length == 0) {
            return message;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        String toReplace = null;
        for (int i = 0; i < replacements.length; ++i) {
            if (i % 2 != 0) {
                replaceMap.put(toReplace, replacements[i]);
                continue;
            }
            toReplace = replacements[i];
        }
        return GeneralUtil.formatComponent(message, replaceMap);
    }

    @Override
    public void reload(LibreLoginPlugin<?, ?> plugin) throws IOException, CorruptedConfigurationException {
        ConfigurateConfiguration adept = new ConfigurateConfiguration(plugin.getDataFolder(), "messages.conf", Set.of(new BiHolder<Class<MessageKeys>, String>(MessageKeys.class, "")), "  !!THIS FILE IS WRITTEN IN THE HOCON FORMAT!!\n  The hocon format is very similar to JSON, but it has some extra features.\n  You can find more information about the format on the sponge wiki:\n  https://docs.spongepowered.org/stable/en/server/getting-started/configuration/hocon.html\n  ----------------------------------------------------------------------------------------\n  LibreLogin Messages\n  ----------------------------------------------------------------------------------------\n  This file contains all of the messages used by the plugin, you are welcome to fit it to your needs.\n  The messages can be written both in the legacy format and in the MiniMessage format. For example, the following message is completely valid: <bold>&aReloaded!</bold>\n  You can find more information about LibreLogin on the github page:\n  https://github.com/Navio1430/LibreLoginProd\n", this.logger, new FirstMessagesMigrator(), new SecondMessagesMigrator(), new ThirdMessagesMigrator());
        this.extractKeys("", adept.getHelper().configuration());
        this.rawMessages = adept;
    }

    private void extractKeys(String prefix, CommentedConfigurationNode node) {
        node.childrenMap().forEach((key, value) -> {
            if (!(key instanceof String)) {
                return;
            }
            String str = (String)key;
            if (value.childrenMap().isEmpty()) {
                String string = value.getString();
                if (string == null) {
                    return;
                }
                this.messages.put(prefix + str, (TextComponent)Component.empty().append(SERIALIZER.deserialize((Object)LegacyMessage.fromLegacy((String)string, (String)"&"))));
            } else {
                this.extractKeys(prefix + str + ".", (CommentedConfigurationNode)value);
            }
        });
    }

    public String getRawMessage(String key) {
        return this.rawMessages.getHelper().getString(key);
    }
}

