/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config.key;

import java.util.function.BiFunction;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;

public class ConfigurationKey<T> {
    private final String key;
    private final BiFunction<ConfigurateHelper, String, T> getter;
    private T defaultValue;
    private String comment;

    public ConfigurationKey(String key, T defaultValue, String comment, BiFunction<ConfigurateHelper, String, T> getter) {
        this.key = key;
        this.getter = getter;
        this.defaultValue = defaultValue;
        this.comment = comment;
    }

    public static ConfigurationKey<?> getComment(String key, String comment) {
        return new ConfigurationKey<Object>(key, null, comment, (x, y) -> {
            throw new UnsupportedOperationException();
        });
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String key() {
        return this.key;
    }

    public BiFunction<ConfigurateHelper, String, T> getter() {
        return this.getter;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public String comment() {
        return this.comment;
    }

    public void setDefault(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T compute(ConfigurateHelper configurateHelper) {
        T value = this.getter.apply(configurateHelper, this.key());
        return value == null ? this.defaultValue : value;
    }
}

